/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.User;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.messagestream.internal.AbstractMessageStreamNotificationFilter;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;

@Component
@Singleton
@Named(value="GroupMessageStreamNotificationFilter")
public class GroupMessageStreamNotificationFilter
extends AbstractMessageStreamNotificationFilter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference userDocumentReference, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        boolean userInGroup;
        XWikiContext xWikiContext;
        User user;
        NotificationFilter.FilterPolicy ret = !this.getEventType().equals(event.getType()) ? NotificationFilter.FilterPolicy.NO_EFFECT : (userDocumentReference != null ? ((user = (xWikiContext = (XWikiContext)this.xcontextProvider.get()).getWiki().getUser(userDocumentReference, xWikiContext)) == null ? NotificationFilter.FilterPolicy.NO_EFFECT : (!(userInGroup = user.isUserInGroup(event.getStream())) ? NotificationFilter.FilterPolicy.FILTER : NotificationFilter.FilterPolicy.NO_EFFECT)) : NotificationFilter.FilterPolicy.FILTER);
        return ret;
    }

    public String getName() {
        return "Group Message Stream Notification Filter";
    }

    @Override
    String getEventType() {
        return "groupMessage";
    }

    public int getPriority() {
        return 2001;
    }
}

