/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.script;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailContentStore;
import org.xwiki.mail.MailResender;
import org.xwiki.mail.MailResult;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;
import org.xwiki.mail.MailStatusStore;
import org.xwiki.mail.MailStorageConfiguration;
import org.xwiki.mail.MailStoreException;
import org.xwiki.mail.internal.DefaultMailResult;
import org.xwiki.mail.script.AbstractMailScriptService;
import org.xwiki.mail.script.ScriptMailResult;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="mailstorage")
@Singleton
@Deprecated
public class DeprecatedMailStorageScriptService
extends AbstractMailScriptService {
    private static final String ERROR_KEY = "scriptservice.mailstorage.error";
    @Inject
    @Named(value="filesystem")
    private MailContentStore mailContentStore;
    @Inject
    @Named(value="database")
    private MailStatusStore mailStatusStore;
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private MailStorageConfiguration storageConfiguration;
    @Inject
    @Named(value="database")
    private MailResender mailResender;

    public ScriptMailResult resend(String batchId, String uniqueMessageId) {
        ScriptMailResult result = this.resendAsynchronously(batchId, uniqueMessageId);
        if (result != null) {
            result.getStatusResult().waitTillProcessed(Long.MAX_VALUE);
        }
        return result;
    }

    public ScriptMailResult resendAsynchronously(String batchId, String uniqueMessageId) {
        try {
            MailStatusResult statusResult = this.mailResender.resendAsynchronously(batchId, uniqueMessageId);
            ScriptMailResult scriptMailResult = new ScriptMailResult((MailResult)new DefaultMailResult(batchId), statusResult);
            return scriptMailResult;
        }
        catch (MailStoreException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public List<ScriptMailResult> resendAsynchronously(Map<String, Object> filterMap, int offset, int count) {
        List<Pair<MailStatus, MailStatusResult>> results;
        try {
            results = this.mailResender.resendAsynchronously(filterMap, offset, count);
        }
        catch (MailStoreException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
        ArrayList<ScriptMailResult> scriptResults = new ArrayList<ScriptMailResult>();
        for (Pair<MailStatus, MailStatusResult> result : results) {
            scriptResults.add(new ScriptMailResult((MailResult)new DefaultMailResult(((MailStatus)result.getLeft()).getBatchId()), (MailStatusResult)result.getRight()));
        }
        return scriptResults;
    }

    public MailStatus load(String uniqueMessageId) {
        try {
            return this.mailStatusStore.load(uniqueMessageId);
        }
        catch (MailStoreException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public List<MailStatus> load(Map<String, Object> filterMap, int offset, int count, String sortField, boolean sortAscending) {
        if (this.authorizationManager.hasAccess(Right.ADMIN)) {
            try {
                return this.mailStatusStore.load(this.normalizeFilterMap(filterMap), offset, count, sortField, sortAscending);
            }
            catch (MailStoreException e) {
                this.setError((Exception)((Object)e));
                return null;
            }
        }
        this.setError((Exception)((Object)new MailStoreException("You need Admin rights to load mail statuses")));
        return null;
    }

    public long count(Map<String, Object> filterMap) {
        if (this.authorizationManager.hasAccess(Right.ADMIN)) {
            try {
                return this.mailStatusStore.count(this.normalizeFilterMap(filterMap));
            }
            catch (MailStoreException e) {
                this.setError((Exception)((Object)e));
                return 0L;
            }
        }
        this.setError((Exception)((Object)new MailStoreException("You need Admin rights to count mail statuses")));
        return 0L;
    }

    public void delete(String batchId) {
        Map<String, Object> filterMap = Collections.singletonMap("batchId", batchId);
        List<MailStatus> statuses = this.load(filterMap, 0, 0, null, false);
        if (statuses != null) {
            for (MailStatus status : statuses) {
                this.delete(batchId, status.getMessageId());
            }
        }
    }

    public void deleteAll() {
        List<MailStatus> statuses = this.load(Collections.emptyMap(), 0, 0, null, false);
        if (statuses != null) {
            for (MailStatus status : statuses) {
                this.delete(status.getBatchId(), status.getMessageId());
            }
        }
    }

    public void delete(String batchId, String uniqueMessageId) {
        try {
            this.mailStatusStore.delete(uniqueMessageId, Collections.emptyMap());
            this.mailContentStore.delete(batchId, uniqueMessageId);
        }
        catch (MailStoreException e) {
            this.setError((Exception)((Object)e));
        }
    }

    public MailStorageConfiguration getConfiguration() {
        return this.storageConfiguration;
    }

    private Map<String, Object> normalizeFilterMap(Map<String, Object> filterMap) {
        HashMap<String, Object> normalizedMap = new HashMap<String, Object>(filterMap);
        XWikiContext xwikiContext = (XWikiContext)this.xwikiContextProvider.get();
        if (!xwikiContext.isMainWiki()) {
            normalizedMap.put("wiki", xwikiContext.getWikiId());
        }
        return normalizedMap;
    }

    private MimeMessage loadMessage(Session session, String batchId, String mailId) throws MailStoreException {
        ExtendedMimeMessage message = this.mailContentStore.load(session, batchId, mailId);
        return message;
    }

    protected String getErrorKey() {
        return ERROR_KEY;
    }
}

