/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusStore;
import org.xwiki.mail.MailStoreException;

@Component
@Named(value="database")
@Singleton
public class DatabaseMailStatusStore
implements MailStatusStore {
    private static final String ID_PARAMETER_NAME = "id";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="hibernate")
    private XWikiStoreInterface hibernateStore;

    @Override
    public void save(MailStatus status, Map<String, Object> parameters) throws MailStoreException {
        XWikiHibernateBaseStore store = (XWikiHibernateBaseStore)this.hibernateStore;
        XWikiContext xwikiContext = (XWikiContext)this.contextProvider.get();
        String currentWiki = xwikiContext.getWikiId();
        xwikiContext.setWikiId(xwikiContext.getMainXWiki());
        try {
            this.delete(status.getMessageId(), parameters);
            store.executeWrite(xwikiContext, session -> {
                session.save((Object)status);
                return null;
            });
            this.logger.debug("Saved mail status [{}]", (Object)status);
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to save mail status [%s] to the database.", status), (Throwable)e);
        }
        finally {
            xwikiContext.setWikiId(currentWiki);
        }
    }

    @Override
    public MailStatus load(String uniqueMessageId) throws MailStoreException {
        List<MailStatus> statuses = this.load(Collections.singletonMap(ID_PARAMETER_NAME, uniqueMessageId), 0, 0, null, false);
        if (statuses.isEmpty()) {
            return null;
        }
        return statuses.get(0);
    }

    @Override
    public List<MailStatus> load(Map<String, Object> filterMap, int offset, int count, String sortField, boolean sortAscending) throws MailStoreException {
        XWikiHibernateBaseStore store = (XWikiHibernateBaseStore)this.hibernateStore;
        XWikiContext xwikiContext = (XWikiContext)this.contextProvider.get();
        String currentWiki = xwikiContext.getWikiId();
        xwikiContext.setWikiId(xwikiContext.getMainXWiki());
        String queryString = this.computeSelectQueryString(filterMap, sortField, sortAscending);
        this.logQuery(queryString, filterMap);
        try {
            List mailStatuses = (List)store.executeRead(xwikiContext, session -> {
                Query query = session.createQuery(queryString, MailStatus.class);
                if (offset > 0) {
                    query.setFirstResult(offset);
                }
                if (count > 0) {
                    query.setMaxResults(count);
                }
                query.setProperties(filterMap);
                return query.list();
            });
            if (this.logger.isDebugEnabled()) {
                for (MailStatus mailStatus : mailStatuses) {
                    this.logger.debug("Loaded mail status [{}]", (Object)mailStatus);
                }
            }
            List list = mailStatuses;
            return list;
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to load mail statuses matching the filter [%s] from the database.", filterMap), (Throwable)e);
        }
        finally {
            xwikiContext.setWikiId(currentWiki);
        }
    }

    @Override
    public long count(Map<String, Object> filterMap) throws MailStoreException {
        XWikiHibernateBaseStore store = (XWikiHibernateBaseStore)this.hibernateStore;
        XWikiContext xwikiContext = (XWikiContext)this.contextProvider.get();
        String currentWiki = xwikiContext.getWikiId();
        xwikiContext.setWikiId(xwikiContext.getMainXWiki());
        String queryString = this.computeCountQueryString(filterMap);
        try {
            long l = (Long)store.executeRead(xwikiContext, session -> {
                Query query = session.createQuery(queryString, Long.class);
                query.setProperties(filterMap);
                return (Long)query.uniqueResult();
            });
            return l;
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to count mail statuses matching the filter [%s] from the database.", filterMap), (Throwable)e);
        }
        finally {
            xwikiContext.setWikiId(currentWiki);
        }
    }

    @Override
    public void delete(String uniqueMessageId, Map<String, Object> parameters) throws MailStoreException {
        XWikiHibernateBaseStore store = (XWikiHibernateBaseStore)this.hibernateStore;
        XWikiContext xwikiContext = (XWikiContext)this.contextProvider.get();
        String currentWiki = xwikiContext.getWikiId();
        xwikiContext.setWikiId(xwikiContext.getMainXWiki());
        try {
            store.executeWrite(xwikiContext, session -> {
                String queryString = String.format("delete from %s where mail_id=:id", MailStatus.class.getName());
                session.createQuery(queryString).setParameter(ID_PARAMETER_NAME, (Object)uniqueMessageId).executeUpdate();
                return null;
            });
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to delete mail status (message id [%s]) from the database.", uniqueMessageId), (Throwable)e);
        }
        finally {
            xwikiContext.setWikiId(currentWiki);
        }
    }

    protected String computeQueryString(String prefix, Map<String, Object> filterMap, String sortField, boolean sortAscending) {
        StringBuilder queryBuilder = new StringBuilder(prefix);
        if (!filterMap.isEmpty()) {
            queryBuilder.append(" where");
            Iterator<String> iterator = filterMap.keySet().iterator();
            while (iterator.hasNext()) {
                String filterKey = iterator.next();
                queryBuilder.append(" mail_").append(filterKey).append(" like ").append(':').append(filterKey);
                if (!iterator.hasNext()) continue;
                queryBuilder.append(" and");
            }
        }
        if (sortField != null) {
            queryBuilder.append(" order by ");
            queryBuilder.append(sortField);
            if (!sortAscending) {
                queryBuilder.append(" desc");
            }
        }
        return queryBuilder.toString();
    }

    protected String computeCountQueryString(Map<String, Object> filterMap) {
        return this.computeQueryString(String.format("select count(*) from %s", MailStatus.class.getName()), filterMap, null, false);
    }

    protected String computeSelectQueryString(Map<String, Object> filterMap, String sortField, boolean sortAscending) {
        return this.computeQueryString(String.format("from %s", MailStatus.class.getName()), filterMap, sortField, sortAscending);
    }

    private void logQuery(String queryString, Map<String, Object> filterMap) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            Iterator<Map.Entry<String, Object>> entryIterator = filterMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<String, Object> entry = entryIterator.next();
                this.addEntryTolog(builder, entry);
                if (!entryIterator.hasNext()) continue;
                builder.append(',').append(' ');
            }
            this.logger.debug("Find mail statuses for query [{}] and parameters [{}]", (Object)queryString, (Object)builder.toString());
        }
    }

    private void addEntryTolog(StringBuilder builder, Map.Entry<String, Object> entry) {
        this.addValueTolog(builder, entry.getKey());
        builder.append(" = ");
        this.addValueTolog(builder, entry.getValue());
    }

    private void addValueTolog(StringBuilder builder, Object value) {
        builder.append('[').append(value).append(']');
    }
}

