/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusStore;
import org.xwiki.mail.MailStoreException;
import org.xwiki.mail.internal.AbstractMailStatusResult;

public class DatabaseMailStatusResult
extends AbstractMailStatusResult {
    private static final String BATCHID_KEY = "batchId";
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseMailStatusResult.class);
    private static final String DATE_FIELD = "date";
    private MailStatusStore mailStatusStore;
    private String batchId;

    public DatabaseMailStatusResult(MailStatusStore mailStatusStore) {
        this.mailStatusStore = mailStatusStore;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Iterator<MailStatus> getAll() {
        if (this.batchId == null) {
            return Collections.emptyIterator();
        }
        try {
            return this.mailStatusStore.load(Collections.singletonMap(BATCHID_KEY, this.batchId), 0, 0, DATE_FIELD, true).iterator();
        }
        catch (MailStoreException e) {
            LOGGER.error("Failed to get all results. Returning an empty result.", (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    public Iterator<MailStatus> getAllErrors() {
        return this.getFilteredState("%_error");
    }

    public Iterator<MailStatus> getByState(MailState state) {
        return this.getFilteredState(state.toString());
    }

    private Iterator<MailStatus> getFilteredState(String state) {
        if (this.batchId == null) {
            return Collections.emptyIterator();
        }
        try {
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put(BATCHID_KEY, this.batchId);
            filterMap.put("state", state);
            return this.mailStatusStore.load(filterMap, 0, 0, DATE_FIELD, true).iterator();
        }
        catch (MailStoreException e) {
            LOGGER.error("Failed to get results by state. Returning an empty result.", (Throwable)e);
            return Collections.emptyIterator();
        }
    }
}

