/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.xar.internal.security.XarSecurityTool;
import org.xwiki.extension.xar.security.ProtectionLevel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.validation.edit.EditConfirmationChecker;
import org.xwiki.model.validation.edit.EditConfirmationCheckerResult;
import org.xwiki.rendering.block.Block;
import org.xwiki.security.authorization.Right;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="securityLevel")
@Priority(value=1000)
public class SecurityLevelEditConfirmationChecker
implements EditConfirmationChecker {
    @Inject
    private XarSecurityTool securityTool;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private TemplateManager templateManager;

    public Optional<EditConfirmationCheckerResult> check() {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        DocumentReference userReference = context.getUserReference();
        XWikiDocument tdoc = (XWikiDocument)context.get((Object)"tdoc");
        DocumentReference documentReference = tdoc.getDocumentReferenceWithLocale();
        ProtectionLevel protectionLevel = this.securityTool.getProtectionLevel(Right.EDIT, userReference, documentReference);
        return switch (protectionLevel) {
            case ProtectionLevel.WARNING -> Optional.of(new EditConfirmationCheckerResult(this.renderMessage(), false, (Serializable)((Object)protectionLevel)));
            case ProtectionLevel.DENY -> Optional.of(new EditConfirmationCheckerResult(this.renderMessage(), true));
            default -> Optional.empty();
        };
    }

    private Block renderMessage() {
        return this.templateManager.executeNoException("extension/handler/xar/securityLevelEditConfirmationChecker.vm");
    }
}

