/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializerManager;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.XarExtensionException;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.handler.packager.DocumentMergeImporter;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.instance.output.DocumentInstanceOutputProperties;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.logging.marker.BeginTranslationMarker;
import org.xwiki.logging.marker.EndTranslationMarker;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.DocumentVersionReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;
import org.xwiki.xar.XarFile;

@Component(roles={Packager.class})
@Singleton
public class Packager {
    private static final BeginTranslationMarker LOG_INSTALLDOCUMENT_BEGIN = new BeginTranslationMarker("extension.xar.log.install.document.begin");
    private static final EndTranslationMarker LOG_INSTALLDOCUMENT_SUCCESS_END = new EndTranslationMarker("extension.xar.log.install.document.success.end");
    private static final EndTranslationMarker LOG_INSTALLDOCUMENT_FAILURE_END = new EndTranslationMarker("extension.xar.log.install.document.failure.end");
    private static final TranslationMarker LOG_DELETEDDOCUMENT = new TranslationMarker("extension.xar.log.delete.document");
    private static final TranslationMarker LOG_DELETEDDOCUMENT_FAILURE = new TranslationMarker("extension.xar.log.delete.document.failure");
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    private Logger logger;
    @Inject
    private ObservationManager observation;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentMergeImporter importer;
    @Inject
    private MandatoryDocumentInitializerManager initializerManager;
    @Inject
    private XWikiDocumentFilterUtils documentImporter;
    @Inject
    private WikiDescriptorManager wikiDescriptors;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedXARs;

    private XarInstalledExtensionRepository getXarInstalledExtensionRepository() {
        return (XarInstalledExtensionRepository)this.installedXARs;
    }

    public void importXAR(String comment, File xarFile, PackageConfiguration configuration) throws IOException, XWikiException, XarException, WikiManagerException {
        if (configuration.getWiki() == null) {
            Collection wikis = this.wikiDescriptors.getAllIds();
            for (String subwiki : wikis) {
                this.importXARToWiki(comment, xarFile, new WikiReference(subwiki), configuration);
            }
        } else {
            this.importXARToWiki(comment, xarFile, new WikiReference(configuration.getWiki()), configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importXARToWiki(String comment, File xarFile, WikiReference wikiReference, PackageConfiguration configuration) throws IOException, XarException, XWikiException {
        try (FileInputStream fis = new FileInputStream(xarFile);){
            this.importXARToWiki(comment, fis, wikiReference, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importXARToWiki(String comment, InputStream xarInputStream, WikiReference wikiReference, PackageConfiguration configuration) throws IOException, XarException, XWikiException {
        ZipArchiveInputStream zis = new ZipArchiveInputStream(xarInputStream);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentWiki = xcontext.getWikiId();
        try {
            xcontext.setWikiId(wikiReference.getName());
            this.observation.notify((Event)new XARImportingEvent(), null, (Object)xcontext);
            ZipArchiveEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && !entry.getName().equals("package.xml")) {
                    if (configuration.getEntriesToImport() != null) {
                        XarEntry xarEntry = configuration.getEntriesToImport().get(entry.getName());
                        if (xarEntry != null) {
                            configuration.setXarEntry(xarEntry);
                            this.importDocumentToWiki(comment, wikiReference, (InputStream)zis, configuration, entry.getName());
                        }
                    } else {
                        configuration.setXarEntry(null);
                        this.importDocumentToWiki(comment, wikiReference, (InputStream)zis, configuration, entry.getName());
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            this.observation.notify((Event)new XARImportedEvent(), null, (Object)xcontext);
            xcontext.setWikiId(currentWiki);
        }
    }

    private void importDocumentToWiki(String comment, WikiReference wikiReference, InputStream inputStream, PackageConfiguration configuration, String name) throws XWikiException, XarException, IOException {
        block6: {
            XWikiDocument nextDocument;
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            try {
                nextDocument = this.getXWikiDocument(inputStream, wikiReference);
            }
            catch (Exception e) {
                this.logger.error("Failed to parse XAR entry [{}]", (Object)name, (Object)e);
                return;
            }
            DocumentReference reference = nextDocument.getDocumentReferenceWithLocale();
            XWikiDocument currentDocument = xcontext.getWiki().getDocument(reference, xcontext);
            currentDocument.loadAttachmentsContentSafe(xcontext);
            XarExtensionPlan xarExtensionPlan = configuration.getXarExtensionPlan();
            XWikiDocument previousDocument = xarExtensionPlan != null ? xarExtensionPlan.getPreviousXWikiDocument(reference, this) : null;
            if (configuration.isVerbose()) {
                this.logger.info((Marker)LOG_INSTALLDOCUMENT_BEGIN, "Installing document [{}]", (Object)nextDocument.getDocumentReferenceWithLocale());
            }
            try {
                this.importer.importDocument(comment, previousDocument, currentDocument, nextDocument, configuration);
                if (configuration.isVerbose()) {
                    this.logger.info((Marker)LOG_INSTALLDOCUMENT_SUCCESS_END, "Done installing document [{}]", (Object)nextDocument.getDocumentReferenceWithLocale());
                }
            }
            catch (Exception e) {
                if (!configuration.isVerbose()) break block6;
                this.logger.error((Marker)LOG_INSTALLDOCUMENT_FAILURE_END, "Failed to install document [{}]", (Object)nextDocument.getDocumentReferenceWithLocale(), (Object)e);
            }
        }
    }

    public void unimportPages(Collection<XarEntry> pages, PackageConfiguration configuration) throws WikiManagerException {
        if (configuration.getWiki() == null) {
            Collection wikis = this.wikiDescriptors.getAllIds();
            for (String subwiki : wikis) {
                this.unimportPagesFromWiki(pages, subwiki, configuration);
            }
        } else {
            this.unimportPagesFromWiki(pages, configuration.getWiki(), configuration);
        }
    }

    private void unimportPagesFromWiki(Collection<XarEntry> entries, String wiki, PackageConfiguration configuration) {
        WikiReference wikiReference = new WikiReference(wiki);
        for (XarEntry xarEntry : entries) {
            if (configuration.getEntriesToImport() != null && !configuration.getEntriesToImport().containsKey(xarEntry.getEntryName())) continue;
            DocumentReference documentReference = new DocumentReference((EntityReference)this.resolver.resolve((Object)xarEntry, new Object[]{wikiReference}), xarEntry.getLocale());
            if (configuration.isSkipMandatorytDocuments() && this.isMandatoryDocument(documentReference)) continue;
            this.deleteDocument(documentReference, configuration);
        }
    }

    public void deleteDocument(DocumentReference documentReference, PackageConfiguration configuration) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument document;
            if (configuration.getUserReference() != null) {
                xcontext.setUserReference(configuration.getUserReference());
            }
            if (!(document = xcontext.getWiki().getDocument(documentReference, xcontext)).isNew()) {
                xcontext.getWiki().deleteDocument(document, xcontext);
                if (configuration.isVerbose()) {
                    this.logger.info((Marker)LOG_DELETEDDOCUMENT, "Deleted document [{}]", (Object)document.getDocumentReferenceWithLocale());
                }
            }
        }
        catch (XWikiException e) {
            this.logger.error((Marker)LOG_DELETEDDOCUMENT_FAILURE, "Failed to delete document [{}]", (Object)documentReference, (Object)e);
        }
    }

    private boolean isMandatoryDocument(DocumentReference documentReference) {
        return this.initializerManager.getMandatoryDocumentInitializer(documentReference) != null;
    }

    public XWikiDocument getXWikiDocument(WikiReference wikiReference, LocalDocumentReference documentReference, XarFile xarFile) throws XarException, IOException {
        XarEntry realEntry = xarFile.getEntry(documentReference);
        if (realEntry != null) {
            try (InputStream stream = xarFile.getInputStream((LocalDocumentReference)realEntry);){
                XWikiDocument xWikiDocument = this.getXWikiDocument(stream, wikiReference);
                return xWikiDocument;
            }
        }
        return null;
    }

    private DocumentReference cleanDocumentReference(DocumentReference reference) {
        DocumentReference documentReference = reference;
        if (reference instanceof DocumentVersionReference) {
            documentReference = ((DocumentVersionReference)reference).removeVersion();
        }
        return documentReference;
    }

    public XWikiDocument getXWikiDocument(DocumentReference reference) throws IOException, XarException {
        Collection<XarInstalledExtension> extensions;
        if (reference != null && !(extensions = this.getXarInstalledExtensionRepository().getXarInstalledExtensions(reference)).isEmpty()) {
            return this.getXWikiDocument(reference, extensions.iterator().next());
        }
        return null;
    }

    public XWikiDocument getXWikiDocument(DocumentReference reference, ExtensionId extensionId) throws IOException, XarException {
        if (reference != null) {
            XarInstalledExtension extension;
            if (extensionId != null && (extension = (XarInstalledExtension)this.installedXARs.getInstalledExtension(extensionId)) != null) {
                return this.getXWikiDocument(reference, extension);
            }
            return this.getXWikiDocument(reference);
        }
        return null;
    }

    public XWikiDocument getXWikiDocument(DocumentReference reference, XarInstalledExtension extension) throws XarException, IOException {
        if (reference != null) {
            DocumentReference documentReference = this.cleanDocumentReference(reference);
            return this.getXWikiDocument(documentReference.getWikiReference(), documentReference.getLocalDocumentReference(), extension);
        }
        return null;
    }

    public XWikiDocument getXWikiDocument(WikiReference wikiReference, LocalDocumentReference documentReference, XarInstalledExtension extension) throws XarException, IOException {
        try (XarFile xarFile = new XarFile(new File(extension.getFile().getAbsolutePath()), extension.getXarPackage());){
            XWikiDocument xWikiDocument = this.getXWikiDocument(wikiReference, documentReference, xarFile);
            return xWikiDocument;
        }
    }

    public XWikiDocument getXWikiDocument(InputStream source, WikiReference wikiReference) throws FilterException, IOException, ComponentLookupException {
        DocumentInstanceOutputProperties documentProperties = new DocumentInstanceOutputProperties();
        documentProperties.setDefaultReference((EntityReference)wikiReference);
        documentProperties.setVersionPreserved(false);
        XARInputProperties xarProperties = new XARInputProperties();
        xarProperties.setWithHistory(false);
        return this.documentImporter.importDocument((InputSource)new DefaultInputStreamInputSource(source), xarProperties, documentProperties);
    }

    public void reset(DocumentReference reference, DocumentReference authorReference) throws IOException, XarException, XWikiException, XarExtensionException {
        XWikiDocument document;
        DocumentReference documentReference;
        XarInstalledExtension extension;
        Collection<XarInstalledExtension> installedExtensions = this.getXarInstalledExtensionRepository().getXarInstalledExtensions(reference);
        if (!installedExtensions.isEmpty()) {
            extension = installedExtensions.iterator().next();
            documentReference = this.cleanDocumentReference(reference);
            document = this.getXWikiDocument(documentReference, extension);
            if (document == null) {
                throw new XarExtensionException("Can't find any document with reference [" + String.valueOf(documentReference) + "] in extension [" + String.valueOf(extension.getId()) + "]");
            }
        } else {
            throw new XarExtensionException("Can't find any installed extension associated with the document reference [" + String.valueOf(reference) + "]");
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument databaseDocument = xcontext.getWiki().getDocument(documentReference, xcontext);
        databaseDocument.apply(document, true);
        databaseDocument.setAuthorReference(authorReference);
        databaseDocument.setContentAuthorReference(authorReference);
        databaseDocument.setMetaDataDirty(true);
        databaseDocument.setContentDirty(true);
        xcontext.getWiki().saveDocument(databaseDocument, "Reset document from extension [" + String.valueOf((Object)extension) + "]", xcontext);
    }

    public List<DocumentReference> getDocumentReferences(Collection<XarEntry> pages, PackageConfiguration configuration) throws WikiManagerException {
        ArrayList<DocumentReference> documents = new ArrayList<DocumentReference>(pages.size());
        if (configuration.getWiki() == null) {
            Collection wikis = this.wikiDescriptors.getAllIds();
            for (String subwiki : wikis) {
                this.getDocumentReferencesFromWiki(documents, pages, subwiki, configuration);
            }
        } else {
            this.getDocumentReferencesFromWiki(documents, pages, configuration.getWiki(), configuration);
        }
        return documents;
    }

    private void getDocumentReferencesFromWiki(List<DocumentReference> documents, Collection<XarEntry> pages, String wiki, PackageConfiguration configuration) {
        WikiReference wikiReference = new WikiReference(wiki);
        for (XarEntry xarEntry : pages) {
            if (configuration.getEntriesToImport() != null && !configuration.getEntriesToImport().containsKey(xarEntry.getEntryName())) continue;
            DocumentReference documentReference = new DocumentReference((LocalDocumentReference)xarEntry, wikiReference);
            if (configuration.isSkipMandatorytDocuments() && this.isMandatoryDocument(documentReference)) continue;
            documents.add(documentReference);
        }
    }
}

