/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.doc.XWikiDocument;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlanEntry;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;
import org.xwiki.xar.XarPackage;

public class XarExtensionPlan
implements Closeable {
    public static final String SESSIONTKEY_XARINSTALLPLAN = "extension.xar.installplan";
    private static final Logger LOGGER = LoggerFactory.getLogger(XarExtensionPlan.class);
    public final Map<String, Map<XarEntry, XarExtensionPlanEntry>> previousXAREntries = new HashMap<String, Map<XarEntry, XarExtensionPlanEntry>>();
    public final Map<String, Map<XarEntry, LocalExtension>> nextXAREntries = new HashMap<String, Map<XarEntry, LocalExtension>>();

    public XarExtensionPlan(ExtensionPlan plan, InstalledExtensionRepository xarRepository, LocalExtensionRepository localReposirory) throws ExtensionException, XarException, IOException {
        HashMap<ExtensionId, XarExtensionPlanEntry> planEntry = new HashMap<ExtensionId, XarExtensionPlanEntry>();
        for (ExtensionPlanAction action : plan.getActions()) {
            if (!"xar".equals(action.getExtension().getType())) continue;
            Collection previousExtensions = action.getPreviousExtensions();
            for (InstalledExtension previousExtension : previousExtensions) {
                if (previousExtension == null || !previousExtension.getType().equals("xar")) continue;
                XarInstalledExtension previousXARExtension = (XarInstalledExtension)xarRepository.getInstalledExtension(previousExtension.getId());
                if (previousXARExtension == null) {
                    LOGGER.error("Installed extension [{}] is not properly registered in the virtual XAR installed extensions repository", (Object)previousExtension);
                    continue;
                }
                XarExtensionPlanEntry xarPlanEntry = (XarExtensionPlanEntry)planEntry.get(previousXARExtension.getId());
                if (xarPlanEntry == null) {
                    xarPlanEntry = new XarExtensionPlanEntry(previousXARExtension, previousXARExtension.getXarPackage());
                    planEntry.put(previousXARExtension.getId(), xarPlanEntry);
                }
                for (XarEntry entry : previousXARExtension.getXarPackage().getEntries()) {
                    String wiki;
                    try {
                        wiki = XarHandlerUtils.getWikiFromNamespace(action.getNamespace());
                    }
                    catch (UnsupportedNamespaceException e) {
                        throw new ExtensionException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                    }
                    Map<XarEntry, XarExtensionPlanEntry> pages = this.previousXAREntries.get(wiki);
                    if (pages == null) {
                        pages = new HashMap<XarEntry, XarExtensionPlanEntry>();
                        this.previousXAREntries.put(wiki, pages);
                    }
                    pages.remove(entry);
                    pages.put(entry, xarPlanEntry);
                }
            }
            LocalExtension nextExtension = action.getAction() != ExtensionPlanAction.Action.UNINSTALL && action.getExtension() != null ? localReposirory.getLocalExtension(action.getExtension().getId()) : null;
            if (nextExtension == null) continue;
            try {
                Collection entries = XarPackage.getEntries((File)new File(nextExtension.getFile().getAbsolutePath()));
                for (XarEntry entry : entries) {
                    String wiki;
                    try {
                        wiki = XarHandlerUtils.getWikiFromNamespace(action.getNamespace());
                    }
                    catch (UnsupportedNamespaceException e) {
                        throw new ExtensionException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                    }
                    Map<XarEntry, LocalExtension> pages = this.nextXAREntries.get(wiki);
                    if (pages == null) {
                        pages = new HashMap<XarEntry, LocalExtension>();
                        this.nextXAREntries.put(wiki, pages);
                    }
                    pages.remove(entry);
                    pages.put(entry, nextExtension);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse extension file [{}]", (Object)nextExtension.getFile().getAbsolutePath(), (Object)e);
            }
        }
    }

    public XarExtensionPlanEntry getPreviousXarExtensionPlanEntry(DocumentReference documentReference) {
        String wiki = documentReference.getWikiReference().getName();
        LocalDocumentReference localDocumentReference = new LocalDocumentReference(documentReference);
        return this.getPreviousXarExtensionPlanEntry(wiki, localDocumentReference);
    }

    public XarExtensionPlanEntry getPreviousXarExtensionPlanEntry(String wiki, LocalDocumentReference localDocumentReference) {
        XarEntry xarEntry = new XarEntry(localDocumentReference);
        XarExtensionPlanEntry planEntry = null;
        Map<XarEntry, XarExtensionPlanEntry> wikiEntry = this.previousXAREntries.get(wiki);
        if (wikiEntry != null) {
            planEntry = wikiEntry.get(xarEntry);
        }
        if (planEntry == null && (wikiEntry = this.previousXAREntries.get(null)) != null) {
            planEntry = wikiEntry.get(xarEntry);
        }
        return planEntry;
    }

    public XarInstalledExtension getPreviousXarExtension(DocumentReference documentReference) {
        String wiki = documentReference.getWikiReference().getName();
        LocalDocumentReference localDocumentReference = new LocalDocumentReference(documentReference);
        return this.getPreviousXarExtension(wiki, localDocumentReference);
    }

    public XarInstalledExtension getPreviousXarExtension(String wiki, LocalDocumentReference localDocumentReference) {
        XarExtensionPlanEntry entry = this.getPreviousXarExtensionPlanEntry(wiki, localDocumentReference);
        return entry != null ? entry.extension : null;
    }

    public LocalExtension getNextXarExtension(DocumentReference documentReference) {
        WikiReference wikiReference = documentReference.getWikiReference();
        LocalDocumentReference localDocumentReference = new LocalDocumentReference(documentReference);
        return this.getNextXarExtension(wikiReference.getName(), localDocumentReference);
    }

    public LocalExtension getNextXarExtension(String wiki, LocalDocumentReference localDocumentReference) {
        XarEntry xarEntry = new XarEntry(localDocumentReference);
        LocalExtension nextExtension = null;
        Map<XarEntry, LocalExtension> wikiEntry = this.nextXAREntries.get(wiki);
        if (wikiEntry != null) {
            nextExtension = wikiEntry.get(xarEntry);
        }
        if (nextExtension == null && (wikiEntry = this.nextXAREntries.get(null)) != null) {
            nextExtension = wikiEntry.get(xarEntry);
        }
        return nextExtension;
    }

    public XWikiDocument getPreviousXWikiDocument(DocumentReference documentReference, Packager packager) throws XarException, IOException {
        WikiReference wikiReference = documentReference.getWikiReference();
        LocalDocumentReference localDocumentReference = new LocalDocumentReference(documentReference);
        return this.getPreviousXWikiDocument(wikiReference, localDocumentReference, packager);
    }

    public XWikiDocument getPreviousXWikiDocument(WikiReference wikiReference, LocalDocumentReference localReference, Packager packager) throws XarException, IOException {
        XarExtensionPlanEntry xarPlanEntry = this.getPreviousXarExtensionPlanEntry(wikiReference.getName(), localReference);
        return xarPlanEntry != null ? packager.getXWikiDocument(wikiReference, localReference, xarPlanEntry.xarFile) : null;
    }

    @Override
    public void close() throws IOException {
        for (Map<XarEntry, XarExtensionPlanEntry> wikiEntry : this.previousXAREntries.values()) {
            for (XarExtensionPlanEntry entry : wikiEntry.values()) {
                entry.close();
            }
        }
    }

    public boolean containsNewPage(DocumentReference documentReference) {
        WikiReference wikiReference = documentReference.getWikiReference();
        LocalDocumentReference localDocumentReference = new LocalDocumentReference(documentReference);
        return this.containsNewPage(wikiReference, localDocumentReference);
    }

    public boolean containsNewPage(WikiReference wikiReference, LocalDocumentReference localDocumentReference) {
        return this.getNextXarExtension(wikiReference.getName(), localDocumentReference) != null;
    }

    public boolean containsNewPages() {
        return !this.nextXAREntries.isEmpty();
    }
}

