/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.ExtensionContext;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.ExtensionSession;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.question.ConflictQuestion;
import org.xwiki.extension.xar.question.DefaultConflictActionQuestion;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;

@Component
@Singleton
@Named(value="xar")
public class XarExtensionHandler
extends AbstractExtensionHandler {
    public static final String TYPE = "xar";
    private static final TranslationMarker LOG_EXTENSIONPLAN_BEGIN = new TranslationMarker("extension.xar.log.extensionplan.begin");
    private static final TranslationMarker LOG_EXTENSIONPLAN_END = new TranslationMarker("extension.xar.log.extensionplan.end");
    private static final String SESSIONKEY_PACKAGECONFIGURATION = "extension.xar.packageconfiguration";
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private LocalExtensionRepository localRepository;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Execution execution;
    @Inject
    private ExtensionContext extensionContext;

    protected static DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    private XarExtensionPlan getXARExtensionPlan() {
        Optional session = this.extensionContext.getExtensionSession();
        if (session.isPresent()) {
            return (XarExtensionPlan)((ExtensionSession)session.get()).get("extension.xar.installplan");
        }
        return null;
    }

    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.installInternal(localExtension, wiki, request);
        }
    }

    public void upgrade(Collection<InstalledExtension> previousLocalExtensions, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.installInternal(newLocalExtension, wiki, request);
        }
    }

    private void installInternal(LocalExtension newLocalExtension, String wiki, Request request) throws InstallException {
        try {
            this.initializeSessionConfiguration(request);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new InstallException("Failed to initialize extension plan index", (Throwable)e);
        }
        PackageConfiguration configuration = this.createPackageConfiguration(newLocalExtension, request, wiki);
        try {
            this.packager.importXAR("Install extension [" + String.valueOf(newLocalExtension) + "]", new File(newLocalExtension.getFile().getAbsolutePath()), configuration);
        }
        catch (Exception e) {
            throw new InstallException("Failed to import xar for extension [" + String.valueOf(newLocalExtension) + "]", (Throwable)e);
        }
    }

    public void uninstall(InstalledExtension installedExtension, String namespace, Request request) throws UninstallException {
        try {
            this.initializeSessionConfiguration(request);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new UninstallException("Failed to initialize extension plan index", (Throwable)e);
        }
        if (!request.isRemote()) {
            Job currentJob;
            Optional extensionSession = this.extensionContext.getExtensionSession();
            try {
                currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            }
            catch (ComponentLookupException e) {
                currentJob = null;
            }
            if (currentJob == null || !extensionSession.isPresent()) {
                String wiki;
                try {
                    wiki = XarHandlerUtils.getWikiFromNamespace(namespace);
                }
                catch (UnsupportedNamespaceException e) {
                    throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                }
                PackageConfiguration configuration = this.createPackageConfiguration(null, request, wiki);
                try {
                    XarInstalledExtension xarLocalExtension = (XarInstalledExtension)this.xarRepository.resolve(installedExtension.getId());
                    Collection pages = xarLocalExtension.getXarPackage().getEntries();
                    this.packager.unimportPages(pages, configuration);
                }
                catch (Exception e) {
                    throw new UninstallException("Failed to get xar extension [" + String.valueOf(installedExtension.getId()) + "] from xar repository", (Throwable)e);
                }
            }
        }
    }

    private void initializeSessionConfiguration(Request request) throws ExtensionException, XarException, IOException, InterruptedException {
        Optional extensionSession = this.extensionContext.getExtensionSession();
        if (extensionSession.isPresent()) {
            this.initializePagesIndex(request, (ExtensionSession)extensionSession.get());
            this.initJobPackageConfiguration(request, (ExtensionSession)extensionSession.get());
        }
    }

    private void initializePagesIndex(Request request, ExtensionSession extensionSession) throws ExtensionException, XarException, IOException {
        ExtensionPlan plan;
        ExecutionContext econtext;
        if (extensionSession.get("extension.xar.installplan") == null && (econtext = this.execution.getContext()) != null && (plan = (ExtensionPlan)econtext.getProperty("job.extension.plan")) != null) {
            if (request.isVerbose()) {
                this.logger.info((Marker)LOG_EXTENSIONPLAN_BEGIN, "Preparing XAR extension plan");
            }
            extensionSession.set("extension.xar.installplan", (Object)new XarExtensionPlan(plan, this.xarRepository, this.localRepository));
            if (request.isVerbose()) {
                this.logger.info((Marker)LOG_EXTENSIONPLAN_END, "XAR extension plan ready");
            }
        }
    }

    private void initJobPackageConfiguration(Request request, ExtensionSession extensionSession) throws InterruptedException {
        if (extensionSession.get(SESSIONKEY_PACKAGECONFIGURATION) == null) {
            Job currentJob = null;
            try {
                currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            }
            catch (Exception e) {
                this.logger.error("Failed to lookup JobContext, it will be impossible to do interactive install");
            }
            if (currentJob != null) {
                PackageConfiguration configuration = new PackageConfiguration();
                extensionSession.set(SESSIONKEY_PACKAGECONFIGURATION, (Object)configuration);
                DocumentReference userReference = XarExtensionHandler.getRequestUserReference("user.reference", request);
                configuration.setInteractive(request.isInteractive());
                configuration.setUser(userReference);
                configuration.setVerbose(request.isVerbose());
                configuration.setSkipMandatorytDocuments(true);
                configuration.setXarExtensionPlan(this.getXARExtensionPlan());
                configuration.setJobStatus(currentJob.getStatus());
                configuration.setConflictAction(ConflictQuestion.ConflictType.CURRENT_DELETED, (ConflictQuestion.GlobalAction)((Object)request.getProperty(ConflictQuestion.REQUEST_CONFLICT_DEFAULTANSWER_CURRENT_DELETED)), ConflictQuestion.GlobalAction.CURRENT);
                configuration.setConflictAction(ConflictQuestion.ConflictType.MERGE_SUCCESS, (ConflictQuestion.GlobalAction)((Object)request.getProperty(ConflictQuestion.REQUEST_CONFLICT_DEFAULTANSWER_MERGE_SUCCESS)), ConflictQuestion.GlobalAction.MERGED);
                configuration.setConflictAction(ConflictQuestion.ConflictType.CURRENT_EXIST, (ConflictQuestion.GlobalAction)((Object)request.getProperty(ConflictQuestion.REQUEST_CONFLICT_DEFAULTANSWER_CURRENT_EXIST)), configuration.isInteractive() ? ConflictQuestion.GlobalAction.ASK : ConflictQuestion.GlobalAction.NEXT);
                configuration.setConflictAction(ConflictQuestion.ConflictType.MERGE_FAILURE, (ConflictQuestion.GlobalAction)((Object)request.getProperty(ConflictQuestion.REQUEST_CONFLICT_DEFAULTANSWER_MERGE_FAILURE)), configuration.isInteractive() ? ConflictQuestion.GlobalAction.ASK : ConflictQuestion.GlobalAction.MERGED);
                XarExtensionPlan xarExtensionPlan = this.getXARExtensionPlan();
                if (currentJob.getStatus().getRequest().isInteractive() && xarExtensionPlan != null && xarExtensionPlan.containsNewPages()) {
                    XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                    xcontext.setUserReference(userReference);
                    int extensionConflictSetup = NumberUtils.toInt((String)xcontext.getWiki().getUserPreference("extensionConflictSetup", xcontext), (int)0);
                    if (extensionConflictSetup == 1) {
                        DefaultConflictActionQuestion question = new DefaultConflictActionQuestion(configuration);
                        currentJob.getStatus().ask((Object)question, 1L, TimeUnit.HOURS);
                    }
                }
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(LocalExtension extension, Request request, String wiki) {
        Optional extensionSession = this.extensionContext.getExtensionSession();
        PackageConfiguration configuration = extensionSession.isPresent() ? (PackageConfiguration)((ExtensionSession)extensionSession.get()).get(SESSIONKEY_PACKAGECONFIGURATION) : null;
        if (configuration != null) {
            configuration = configuration.clone();
        } else {
            configuration = new PackageConfiguration();
            DocumentReference userReference = XarExtensionHandler.getRequestUserReference("user.reference", request);
            configuration.setInteractive(request.isInteractive());
            configuration.setUser(userReference);
            configuration.setVerbose(request.isVerbose());
            configuration.setSkipMandatorytDocuments(true);
        }
        configuration.setWiki(wiki);
        if (extension != null && configuration.getXarExtensionPlan() != null) {
            Map<XarEntry, LocalExtension> nextXAREntriesOnWiki;
            Map<String, Map<XarEntry, LocalExtension>> nextXAREntries = configuration.getXarExtensionPlan().nextXAREntries;
            HashMap<String, XarEntry> entriesToImport = new HashMap<String, XarEntry>();
            Map<XarEntry, LocalExtension> nextXAREntriesOnRoot = nextXAREntries.get(null);
            if (nextXAREntriesOnRoot != null) {
                for (Map.Entry<XarEntry, LocalExtension> entry : nextXAREntriesOnRoot.entrySet()) {
                    if (entry.getValue() != extension) continue;
                    entriesToImport.put(entry.getKey().getEntryName(), entry.getKey());
                }
            }
            if ((nextXAREntriesOnWiki = nextXAREntries.get(wiki)) != null) {
                for (Map.Entry<XarEntry, LocalExtension> entry : nextXAREntriesOnWiki.entrySet()) {
                    if (entry.getValue() != extension) continue;
                    entriesToImport.put(entry.getKey().getEntryName(), entry.getKey());
                }
            }
            configuration.setEntriesToImport(entriesToImport);
        }
        return configuration;
    }
}

