/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.filters.expression.AndNode;
import org.xwiki.notifications.filters.expression.BooleanValueNode;
import org.xwiki.notifications.filters.expression.ConcatNode;
import org.xwiki.notifications.filters.expression.DateValueNode;
import org.xwiki.notifications.filters.expression.EndsWith;
import org.xwiki.notifications.filters.expression.EntityReferenceNode;
import org.xwiki.notifications.filters.expression.EqualsNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.GreaterThanNode;
import org.xwiki.notifications.filters.expression.InNode;
import org.xwiki.notifications.filters.expression.InSubQueryNode;
import org.xwiki.notifications.filters.expression.LesserThanNode;
import org.xwiki.notifications.filters.expression.NotEqualsNode;
import org.xwiki.notifications.filters.expression.NotNode;
import org.xwiki.notifications.filters.expression.OrNode;
import org.xwiki.notifications.filters.expression.PropertyValueNode;
import org.xwiki.notifications.filters.expression.StartsWith;
import org.xwiki.notifications.filters.expression.StringValueNode;
import org.xwiki.notifications.filters.expression.generics.AbstractBinaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractUnaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;
import org.xwiki.notifications.filters.internal.status.ForUserNode;
import org.xwiki.notifications.sources.internal.OrderByNode;

@Component(roles={ExpressionNodeToHQLConverter.class})
@Singleton
public class ExpressionNodeToHQLConverter {
    private static final String VARIABLE_NAME = ":%s";
    private static final EnumMap<EventProperty, String> PROPERTY_MAPPING = new EnumMap(EventProperty.class);
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public HQLQuery parse(ExpressionNode node) {
        HQLQuery result = new HQLQuery();
        result.query = this.parseBlock(node, result);
        return result;
    }

    private String parseBlock(ExpressionNode node, HQLQuery result) {
        if (node instanceof AbstractValueNode) {
            return this.parseValue((AbstractValueNode)node, result);
        }
        if (node instanceof AbstractUnaryOperatorNode) {
            return this.parseUnaryOperator((AbstractUnaryOperatorNode)node, result);
        }
        if (node instanceof AbstractBinaryOperatorNode) {
            return this.parseBinaryOperator((AbstractBinaryOperatorNode)node, result);
        }
        if (node instanceof AbstractOperatorNode) {
            return this.parseOtherOperation((AbstractOperatorNode)node, result);
        }
        return "";
    }

    private String parseValue(AbstractValueNode value, HQLQuery result) {
        return this.parseValue(value, false, result);
    }

    private String parseValue(AbstractValueNode value, boolean escape, HQLQuery result) {
        String returnValue;
        if (value instanceof PropertyValueNode) {
            returnValue = PROPERTY_MAPPING.get(((PropertyValueNode)value).getContent());
            if (returnValue == null) {
                returnValue = "";
            }
        } else if (value instanceof StringValueNode) {
            StringValueNode valueNode = (StringValueNode)value;
            String nodeContent = escape ? this.escape((String)valueNode.getContent()) : (String)valueNode.getContent();
            String mapKey = String.format("value_%s", DigestUtils.sha256Hex((String)((String)valueNode.getContent())));
            result.queryParameters.put(mapKey, nodeContent);
            returnValue = String.format(VARIABLE_NAME, mapKey);
        } else if (value instanceof EntityReferenceNode) {
            String stringValue = (String)this.serializer.serialize((EntityReference)((EntityReferenceNode)value).getContent(), new Object[0]);
            if (escape) {
                stringValue = this.escape(stringValue);
            }
            String mapKey = String.format("entity_%s", DigestUtils.sha256Hex((String)stringValue));
            result.queryParameters.put(mapKey, stringValue);
            returnValue = String.format(VARIABLE_NAME, mapKey);
        } else if (value instanceof DateValueNode) {
            DateValueNode dateValueNode = (DateValueNode)value;
            String stringValue = ((Date)dateValueNode.getContent()).toString();
            String mapKey = String.format("date_%s", DigestUtils.sha256Hex((String)stringValue));
            result.queryParameters.put(mapKey, dateValueNode.getContent());
            returnValue = String.format(VARIABLE_NAME, mapKey);
        } else if (value instanceof BooleanValueNode) {
            returnValue = ((Boolean)((BooleanValueNode)value).getContent()).toString();
        } else if (value instanceof ConcatNode) {
            ConcatNode node = (ConcatNode)value;
            returnValue = String.format("CONCAT(%s, %s)", this.parseBlock((ExpressionNode)node.getLeftOperand(), result), this.parseBlock((ExpressionNode)node.getRightOperand(), result));
        } else {
            returnValue = "";
        }
        return returnValue;
    }

    private String parseUnaryOperator(AbstractUnaryOperatorNode operator, HQLQuery result) {
        if (operator instanceof NotNode) {
            return String.format(" NOT (%s)", this.parseBlock((ExpressionNode)operator.getOperand(), result));
        }
        return "";
    }

    private String parseBinaryOperator(AbstractBinaryOperatorNode operator, HQLQuery result) {
        String returnValue;
        if (operator instanceof AndNode) {
            returnValue = String.format("(%s) AND (%s)", this.parseBlock((ExpressionNode)operator.getLeftOperand(), result), this.parseBlock((ExpressionNode)operator.getRightOperand(), result));
        } else if (operator instanceof OrNode) {
            returnValue = String.format("(%s) OR (%s)", this.parseBlock((ExpressionNode)operator.getLeftOperand(), result), this.parseBlock((ExpressionNode)operator.getRightOperand(), result), result);
        } else if (operator instanceof EqualsNode) {
            returnValue = String.format("%s = %s", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), result));
        } else if (operator instanceof NotEqualsNode) {
            returnValue = String.format("%s <> %s", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), result));
        } else if (operator instanceof StartsWith) {
            returnValue = String.format("%s LIKE concat(%s, '%%') ESCAPE '!'", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), true, result));
        } else if (operator instanceof EndsWith) {
            returnValue = String.format("%s LIKE concat('%%', %s) ESCAPE '!'", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), true, result));
        } else if (operator instanceof GreaterThanNode) {
            GreaterThanNode greater = (GreaterThanNode)operator;
            returnValue = String.format("%s %s %s", this.parseBlock((ExpressionNode)greater.getLeftOperand(), result), greater.isOrEquals() ? ">=" : ">", this.parseBlock((ExpressionNode)greater.getRightOperand(), result));
        } else if (operator instanceof LesserThanNode) {
            LesserThanNode lesser = (LesserThanNode)operator;
            returnValue = String.format("%s %s %s", this.parseBlock((ExpressionNode)lesser.getLeftOperand(), result), lesser.isOrEquals() ? "<=" : "<", this.parseBlock((ExpressionNode)lesser.getRightOperand(), result));
        } else {
            returnValue = "";
        }
        return returnValue;
    }

    private String parseOtherOperation(AbstractOperatorNode operator, HQLQuery result) {
        String returnValue;
        if (operator instanceof InNode) {
            InNode inOperator = (InNode)operator;
            if (inOperator.getValues().isEmpty()) {
                returnValue = "true = false";
            } else {
                StringBuilder builder = new StringBuilder(this.parseBlock((ExpressionNode)inOperator.getLeftOperand(), result));
                builder.append(" IN (");
                String separator = "";
                for (AbstractValueNode value : inOperator.getValues()) {
                    builder.append(separator);
                    builder.append(this.parseBlock((ExpressionNode)value, result));
                    separator = ", ";
                }
                builder.append(")");
                returnValue = builder.toString();
            }
        } else if (operator instanceof InSubQueryNode) {
            InSubQueryNode inSubQueryOperator = (InSubQueryNode)operator;
            StringBuilder builder = new StringBuilder(this.parseBlock((ExpressionNode)inSubQueryOperator.getLeftOperand(), result));
            builder.append(" IN (");
            builder.append(inSubQueryOperator.getSubQuery());
            builder.append(")");
            returnValue = builder.toString();
            result.getQueryParameters().putAll(inSubQueryOperator.getParameters());
        } else if (operator instanceof OrderByNode) {
            OrderByNode orderByNode = (OrderByNode)operator;
            returnValue = String.format("%s ORDER BY %s %s", this.parseBlock((ExpressionNode)orderByNode.getQuery(), result), this.parseBlock((ExpressionNode)orderByNode.getProperty(), result), orderByNode.getOrder().name());
        } else if (operator instanceof ForUserNode) {
            ForUserNode forUser = (ForUserNode)operator;
            StringBuilder builder = new StringBuilder("event IN (");
            builder.append("select status.activityEvent from LegacyEventStatus status");
            builder.append(" where status.activityEvent = event and status.entityId = :userStatusRead");
            if (forUser.isRead() != null) {
                builder.append(" and status.read = " + forUser.isRead());
            }
            builder.append(')');
            returnValue = builder.toString();
            result.getQueryParameters().put("userStatusRead", this.serializer.serialize((EntityReference)forUser.getUser(), new Object[0]));
        } else {
            returnValue = "";
        }
        return returnValue;
    }

    private String escape(String format) {
        return format.replaceAll("([%_!])", "!$1");
    }

    static {
        PROPERTY_MAPPING.put(EventProperty.ID, "event.id");
        PROPERTY_MAPPING.put(EventProperty.GROUP_ID, "event.requestId");
        PROPERTY_MAPPING.put(EventProperty.STREAM, "event.stream");
        PROPERTY_MAPPING.put(EventProperty.DATE, "event.date");
        PROPERTY_MAPPING.put(EventProperty.IMPORTANCE, "event.priority");
        PROPERTY_MAPPING.put(EventProperty.TYPE, "event.type");
        PROPERTY_MAPPING.put(EventProperty.APPLICATION, "event.application");
        PROPERTY_MAPPING.put(EventProperty.USER, "event.user");
        PROPERTY_MAPPING.put(EventProperty.WIKI, "event.wiki");
        PROPERTY_MAPPING.put(EventProperty.SPACE, "event.space");
        PROPERTY_MAPPING.put(EventProperty.PAGE, "event.page");
        PROPERTY_MAPPING.put(EventProperty.HIDDEN, "event.hidden");
        PROPERTY_MAPPING.put(EventProperty.URL, "event.url");
        PROPERTY_MAPPING.put(EventProperty.TITLE, "event.title");
        PROPERTY_MAPPING.put(EventProperty.BODY, "event.body");
        PROPERTY_MAPPING.put(EventProperty.DOCUMENT_VERSION, "event.version");
    }

    public static final class HQLQuery {
        private String query;
        private Map<String, Object> queryParameters = new HashMap<String, Object>();

        public String getQuery() {
            return this.query;
        }

        public Map<String, Object> getQueryParameters() {
            return this.queryParameters;
        }
    }
}

