/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component(roles={LegacyEventStreamStoreConfiguration.class})
@Singleton
public class LegacyEventStreamStoreConfiguration {
    private static final String LEGACY_PREFERENCE_PREFIX = "xwiki.plugin.activitystream.";
    private static final String PREFERENCE_PREFIX = "eventstream.";
    private static final String DAYS_TO_KEEP_EVENTS = "daystokeepevents";
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource legacyConfigurationSource;
    @Inject
    private ConfigurationSource configurationSource;

    public boolean useLocalStore() {
        if (!this.useMainStore()) {
            return true;
        }
        return this.getProperty("uselocalstore", true);
    }

    public boolean useMainStore() {
        return this.getProperty("usemainstore", true);
    }

    private boolean getProperty(String name, boolean defaultValue) {
        if (this.configurationSource.containsKey(PREFERENCE_PREFIX + name)) {
            return (Boolean)this.configurationSource.getProperty(PREFERENCE_PREFIX + name, (Object)defaultValue);
        }
        if (this.legacyConfigurationSource.containsKey(LEGACY_PREFERENCE_PREFIX + name)) {
            return (Boolean)this.legacyConfigurationSource.getProperty(LEGACY_PREFERENCE_PREFIX + name, (Object)defaultValue);
        }
        return defaultValue;
    }

    public int getNumberOfDaysToKeep() {
        return (Integer)this.configurationSource.getProperty("eventstream.daystokeepevents", (Object)((Integer)this.legacyConfigurationSource.getProperty("xwiki.plugin.activitystream.daystokeepevents", (Object)0)));
    }
}

