/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStatusManager;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.eventstream.store.internal.LegacyEventConverter;
import org.xwiki.eventstream.store.internal.LegacyEventStatus;
import org.xwiki.eventstream.store.internal.LegacyEventStreamStoreConfiguration;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class LegacyEventStatusManager
implements EventStatusManager {
    @Inject
    private QueryManager queryManager;
    @Inject
    private LegacyEventConverter eventConverter;
    @Inject
    private LegacyEventStreamStoreConfiguration configuration;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NamespaceContextExecutor namespaceContextExecutor;

    @Override
    public List<EventStatus> getEventStatus(List<Event> events, List<String> entityIds) throws Exception {
        ArrayList<EventStatus> results = new ArrayList<EventStatus>();
        if (events.isEmpty() || entityIds.isEmpty()) {
            return results;
        }
        Query query = this.queryManager.createQuery("select eventStatus from LegacyEventStatus eventStatus where eventStatus.activityEvent.id in :eventIds and eventStatus.entityId in :entityIds", "hql");
        query.bindValue("eventIds", this.getEventIds(events));
        query.bindValue("entityIds", entityIds);
        for (LegacyEventStatus legacyEventStatus : query.execute()) {
            results.add((EventStatus)new DefaultEventStatus(this.eventConverter.convertLegacyActivityToEvent(legacyEventStatus.getActivityEvent()), legacyEventStatus.getEntityId(), legacyEventStatus.isRead()));
        }
        for (Event event : events) {
            for (String entityId : entityIds) {
                if (this.isPresent(event, entityId, results)) continue;
                results.add((EventStatus)new DefaultEventStatus(event, entityId, false));
            }
        }
        Collections.sort(results, (status1, status2) -> status2.getEvent().getDate().compareTo(status1.getEvent().getDate()));
        return results;
    }

    private List<String> getEventIds(List<Event> events) {
        ArrayList<String> eventIds = new ArrayList<String>();
        for (Event event : events) {
            eventIds.add(event.getId());
        }
        return eventIds;
    }

    private boolean isPresent(Event event, String entityId, List<EventStatus> list) {
        for (EventStatus status : list) {
            if (!StringUtils.equals((CharSequence)status.getEvent().getId(), (CharSequence)event.getId()) || !StringUtils.equals((CharSequence)status.getEntityId(), (CharSequence)entityId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveEventStatus(EventStatus eventStatus) throws Exception {
        LegacyEventStatus status = this.eventConverter.convertEventStatusToLegacyActivityStatus(eventStatus);
        boolean isSavedOnMainStore = false;
        if (this.configuration.useLocalStore()) {
            String currentWiki = this.wikiDescriptorManager.getCurrentWikiId();
            this.saveEventStatusInStore(status, currentWiki);
            isSavedOnMainStore = this.wikiDescriptorManager.isMainWiki(currentWiki);
        }
        if (this.configuration.useMainStore() && !isSavedOnMainStore) {
            this.saveEventStatusInStore(status, this.wikiDescriptorManager.getMainWikiId());
        }
    }

    @Override
    @Deprecated
    public void deleteEventStatus(EventStatus eventStatus) throws Exception {
        LegacyEventStatus status = this.eventConverter.convertEventStatusToLegacyActivityStatus(eventStatus);
        boolean isSavedOnMainStore = false;
        if (this.configuration.useLocalStore()) {
            String currentWiki = this.wikiDescriptorManager.getCurrentWikiId();
            this.deleteEventStatusFromStore(status, currentWiki);
            isSavedOnMainStore = this.wikiDescriptorManager.isMainWiki(currentWiki);
        }
        if (this.configuration.useMainStore() && !isSavedOnMainStore) {
            this.deleteEventStatusFromStore(status, this.wikiDescriptorManager.getMainWikiId());
        }
    }

    private void saveEventStatusInStore(LegacyEventStatus eventStatus, String wikiId) throws Exception {
        this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(wikiId), () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            try {
                hibernateStore.executeWrite(context, session -> {
                    session.saveOrUpdate((Object)eventStatus);
                    return null;
                });
            }
            catch (XWikiException e) {
                throw new EventStreamException((Throwable)e);
            }
            return null;
        });
    }

    private void deleteEventStatusFromStore(LegacyEventStatus eventStatus, String wikiId) throws Exception {
        this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(wikiId), () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            try {
                hibernateStore.executeWrite(context, session -> {
                    session.delete((Object)eventStatus);
                    return null;
                });
            }
            catch (XWikiException e) {
                throw new EventStreamException((Throwable)e);
            }
            return null;
        });
    }

    @Override
    @Deprecated
    public void deleteAllForEntity(Date startDate, String entityId) throws Exception {
        boolean isSavedOnMainStore = false;
        if (this.configuration.useLocalStore()) {
            String currentWiki = this.wikiDescriptorManager.getCurrentWikiId();
            this.deleteAllForEntityInStore(startDate, entityId, currentWiki);
            isSavedOnMainStore = this.wikiDescriptorManager.isMainWiki(currentWiki);
        }
        if (this.configuration.useMainStore() && !isSavedOnMainStore) {
            this.deleteAllForEntityInStore(startDate, entityId, this.wikiDescriptorManager.getMainWikiId());
        }
    }

    private void deleteAllForEntityInStore(Date startDate, String entityId, String wikiId) throws Exception {
        this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(wikiId), () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            try {
                hibernateStore.executeWrite(context, session -> this.deleteAllForEntityInStore(session, startDate, entityId));
            }
            catch (XWikiException e) {
                throw new EventStreamException((Throwable)e);
            }
            return null;
        });
    }

    private Object deleteAllForEntityInStore(Session session, Date startDate, String entityId) {
        StringBuilder statement = new StringBuilder("delete from LegacyEventStatus status where status.entityId = :entityId");
        if (startDate != null) {
            statement.append(" and status.activityEvent in ");
            statement.append("(select event from LegacyEvent event where event.date < :startDate)");
        }
        org.hibernate.query.Query query = session.createQuery(statement.toString());
        query.setParameter("entityId", (Object)entityId);
        if (startDate != null) {
            query.setParameter("startDate", (Object)startDate);
        }
        query.executeUpdate();
        return null;
    }

    public void deleteAllForEventInStore(Session session, String eventId) {
        StringBuilder statement = new StringBuilder("delete from LegacyEventStatus status where status.activityEvent.id = :eventId");
        org.hibernate.query.Query query = session.createQuery(statement.toString());
        query.setParameter("eventId", (Object)eventId);
        query.executeUpdate();
    }
}

