/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.scheduler.SchedulerPlugin;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.store.internal.EventStreamCleanerJob;
import org.xwiki.eventstream.store.internal.LegacyEventStreamStoreConfiguration;
import org.xwiki.model.internal.document.DefaultDocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;

@Component
@Singleton
@Named(value="Event Stream cleaner")
public class EventStreamCleanerJobDocumentInitializer
extends AbstractEventListener {
    public static final String CLEANER_JOB_NAME = "Event Stream cleaner";
    private static final LocalDocumentReference CLEANER_JOB_REF = new LocalDocumentReference("Scheduler", "EventStreamCleanerJob");
    private static final String CLEANER_JOB_CRON = "0 0 0 ? * SUN";
    private static final String MAIN_WIKI = "xwiki";
    private static final String XWIKI = "XWiki";
    private static final DocumentReference SUPER_ADMIN = new DocumentReference("xwiki", "XWiki", "superadmin");
    private static final LocalDocumentReference XWIKI_RIGHTS_CLASS = new LocalDocumentReference("XWiki", "XWikiRights");
    @Inject
    private Logger logger;
    @Inject
    private LegacyEventStreamStoreConfiguration configuration;
    @Inject
    private Provider<XWikiContext> contextProvider;

    public EventStreamCleanerJobDocumentInitializer() {
        super(CLEANER_JOB_NAME, new Event[]{new WikiReadyEvent(), new ApplicationReadyEvent()});
    }

    private boolean setCleanerCommonDocumentsFields(XWikiDocument doc) {
        boolean needsUpdate = false;
        DefaultDocumentAuthors authors = new DefaultDocumentAuthors(doc);
        if (authors.getEffectiveMetadataAuthor() == null) {
            needsUpdate = true;
            authors.setEffectiveMetadataAuthor((UserReference)SuperAdminUserReference.INSTANCE);
        }
        if (authors.getCreator() == null) {
            needsUpdate = true;
            authors.setCreator((UserReference)SuperAdminUserReference.INSTANCE);
        }
        if (doc.getParentReference() == null) {
            needsUpdate = true;
            doc.setParentReference((EntityReference)new LocalDocumentReference(CLEANER_JOB_REF.getParent().getName(), "WebHome"));
        }
        return needsUpdate;
    }

    private boolean createWatchListJobRightsObject(XWikiDocument doc, XWikiContext context) throws XWikiException {
        BaseObject rights = doc.getXObject((EntityReference)XWIKI_RIGHTS_CLASS);
        if (rights == null) {
            int index = doc.createXObject((EntityReference)XWIKI_RIGHTS_CLASS, context);
            rights = doc.getXObject((EntityReference)XWIKI_RIGHTS_CLASS, index);
            rights.setLargeStringValue("groups", "XWiki.XWikiAdminGroup");
            rights.setStringValue("levels", "edit,delete");
            rights.setIntValue("allow", 1);
            return true;
        }
        return false;
    }

    private void initCleanerJob() {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument doc = context.getWiki().getDocument((EntityReference)CLEANER_JOB_REF, context);
            doc = doc.clone();
            boolean needsUpdate = this.setCleanerCommonDocumentsFields(doc);
            BaseObject job = doc.getXObject(SchedulerPlugin.XWIKI_JOB_CLASSREFERENCE);
            if (job == null) {
                needsUpdate = true;
                job = doc.newXObject(SchedulerPlugin.XWIKI_JOB_CLASSREFERENCE, context);
                job.setStringValue("jobName", CLEANER_JOB_NAME);
                job.setStringValue("jobClass", EventStreamCleanerJob.class.getName());
                job.setStringValue("cron", CLEANER_JOB_CRON);
                job.setStringValue("contextUser", "xwiki:XWiki.superadmin");
                job.setStringValue("contextLang", "en");
                job.setStringValue("contextDatabase", MAIN_WIKI);
            }
            needsUpdate |= this.createWatchListJobRightsObject(doc, context);
            if (StringUtils.isBlank((CharSequence)doc.getContent())) {
                needsUpdate = true;
                doc.setContent("{{include reference=\"XWiki.SchedulerJobSheet\"/}}");
                doc.setSyntax(Syntax.XWIKI_2_0);
            }
            if (needsUpdate) {
                context.getWiki().saveDocument(doc, "", true, context);
                ((SchedulerPlugin)context.getWiki().getPlugin("scheduler", context)).scheduleJob(job, context);
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot initialize EventStreamCleanerJob", (Throwable)e);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.configuration.getNumberOfDaysToKeep() > 0) {
            this.initCleanerJob();
        }
    }
}

