/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.store.internal.AbstractLegacyEventConverter;
import org.xwiki.eventstream.store.internal.LegacyEvent;
import org.xwiki.eventstream.store.internal.LegacyEventConverter;
import org.xwiki.eventstream.store.internal.LegacyEventStatus;

@Component
@Singleton
public class DefaultLegacyEventConverter
extends AbstractLegacyEventConverter {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    private LegacyEventConverter getConverterForType(String type) {
        if (!StringUtils.isEmpty((CharSequence)type) && !"default".equals(type) && this.componentManager.hasComponent(LegacyEventConverter.class, type)) {
            try {
                return (LegacyEventConverter)this.componentManager.getInstance(LegacyEventConverter.class, type);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Error while initializing LegacyEventConverter with hint [{}]. Fallback on default converter.", (Object)type, (Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public LegacyEvent convertEventToLegacyActivity(Event e) {
        LegacyEventConverter converter = this.getConverterForType(e.getType());
        LegacyEvent result = converter == null ? super.convertEventToLegacyActivity(e) : converter.convertEventToLegacyActivity(e);
        return result;
    }

    @Override
    public Event convertLegacyActivityToEvent(LegacyEvent e) {
        LegacyEventConverter converter = this.getConverterForType(e.getType());
        Event result = converter == null ? super.convertLegacyActivityToEvent(e) : converter.convertLegacyActivityToEvent(e);
        return result;
    }

    @Override
    public LegacyEventStatus convertEventStatusToLegacyActivityStatus(EventStatus eventStatus) {
        LegacyEventConverter converter;
        LegacyEventStatus result = null;
        if (eventStatus.getEvent() != null && (converter = this.getConverterForType(eventStatus.getEvent().getType())) != null) {
            result = converter.convertEventStatusToLegacyActivityStatus(eventStatus);
        }
        if (result == null) {
            result = super.convertEventStatusToLegacyActivityStatus(eventStatus);
        }
        return result;
    }

    @Override
    public EventStatus convertLegacyActivityStatusToEventStatus(LegacyEventStatus eventStatus) {
        LegacyEventConverter converter;
        EventStatus result = null;
        if (eventStatus.getActivityEvent() != null && (converter = this.getConverterForType(eventStatus.getActivityEvent().getType())) != null) {
            result = converter.convertLegacyActivityStatusToEventStatus(eventStatus);
        }
        if (result == null) {
            result = super.convertLegacyActivityStatusToEventStatus(eventStatus);
        }
        return result;
    }
}

