/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.store.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventSearchResult;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStatusManager;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.AbstractAsynchronousEventStore;
import org.xwiki.eventstream.internal.EmptyEventSearchResult;
import org.xwiki.query.QueryException;

public abstract class AbstractLegacyEventStore
extends AbstractAsynchronousEventStore {
    @Inject
    private EventStream eventStream;
    @Inject
    private EventStatusManager eventStatusManager;

    protected Event syncSaveEvent(Event event) throws EventStreamException {
        this.eventStream.addEvent(event);
        return event;
    }

    protected Optional<Event> syncDeleteEvent(String eventId) throws EventStreamException {
        Optional<Event> existingEvent = this.getEvent(eventId);
        if (existingEvent.isPresent()) {
            this.eventStream.deleteEvent(existingEvent.get());
        }
        return existingEvent;
    }

    protected Optional<Event> syncDeleteEvent(Event event) throws EventStreamException {
        Optional<Event> existingEvent = this.getEvent(event.getId());
        if (existingEvent.isPresent()) {
            this.eventStream.deleteEvent(event);
        }
        return existingEvent;
    }

    protected EventStatus syncSaveEventStatus(EventStatus status) throws EventStreamException {
        try {
            this.eventStatusManager.saveEventStatus(status);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to save the status in the old event store", (Throwable)e);
        }
        return status;
    }

    protected EntityEvent syncSaveMailEntityEvent(EntityEvent event) throws EventStreamException {
        return event;
    }

    protected Optional<EventStatus> syncDeleteEventStatus(EventStatus status) throws EventStreamException {
        try {
            this.eventStatusManager.deleteEventStatus(status);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to delete the status from the old event store", (Throwable)e);
        }
        return Optional.of(status);
    }

    protected Void syncDeleteEventStatuses(String entityId, Date date) throws EventStreamException {
        try {
            this.eventStatusManager.deleteAllForEntity(date, entityId);
        }
        catch (Exception e) {
            throw new EventStreamException("Failed to delete the statuses from the old event store", (Throwable)e);
        }
        return null;
    }

    public List<EventStatus> getEventStatuses(Collection<Event> events, Collection<String> entityIds) throws Exception {
        return this.eventStatusManager.getEventStatus((List<Event>)(events instanceof List ? (List<Object>)events : new ArrayList<Event>(events)), (List<String>)(events instanceof List ? (List<Object>)entityIds : new ArrayList<String>(entityIds)));
    }

    protected Optional<EntityEvent> syncDeleteMailEntityEvent(EntityEvent event) throws EventStreamException {
        return Optional.empty();
    }

    protected Event syncPrefilterEvent(Event event) throws EventStreamException {
        return event;
    }

    public Optional<Event> getEvent(String eventId) throws EventStreamException {
        try {
            return Optional.ofNullable(this.eventStream.getEvent(eventId));
        }
        catch (QueryException e) {
            throw new EventStreamException("Failed to get event from the old store", (Throwable)e);
        }
    }

    public EventSearchResult search(EventQuery query) throws EventStreamException {
        return EmptyEventSearchResult.INSTANCE;
    }

    public EventSearchResult search(EventQuery query, Set<String> fields) throws EventStreamException {
        return EmptyEventSearchResult.INSTANCE;
    }
}

