/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.script;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.internal.LegacyEventMigrationRequest;
import org.xwiki.eventstream.script.EventStreamScriptService;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.query.QueryException;

@Component
@Singleton
@Named(value="eventstream")
public class LegacyEventStreamScriptService
extends EventStreamScriptService {
    private static final List<String> LEGACY_MIGRATOR_ID = Arrays.asList("event", "legacy", "migrator");
    @Inject
    private JobExecutor jobs;
    @Inject
    private JobStatusStore statuses;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private EventStream eventStream;

    public JobStatus getLegacyMigrationStatus() {
        Job job = this.jobs.getJob(LEGACY_MIGRATOR_ID);
        if (job != null) {
            return job.getStatus();
        }
        return this.statuses.getJobStatus(LEGACY_MIGRATOR_ID);
    }

    public JobStatus startLegacyMigration(Date since) throws JobException {
        return this.jobs.execute("eventstream.legacycopy", (Request)new LegacyEventMigrationRequest(since, LEGACY_MIGRATOR_ID)).getStatus();
    }

    private EventStream getEventStream() {
        if (this.eventStream == null && this.componentManager.hasComponent(EventStream.class)) {
            try {
                this.eventStream = (EventStream)this.componentManager.getInstance(EventStream.class);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup EventStream legacy component", (Throwable)e);
            }
        }
        return this.eventStream;
    }

    public long getLegacyEventCount() throws QueryException {
        return this.getEventStream() != null ? this.eventStream.countEvents() : 0L;
    }
}

