/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.handler.internal.question;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.event.status.CancelableJobStatus;
import org.xwiki.job.handler.internal.AbstractTemplateJobResourceReferenceHandler;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.BeanManager;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.properties.PropertyException;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.url.internal.ParentResourceReference;

@Component
@Named(value="question")
@Singleton
public class QuestionJobResourceReferenceHandler
extends AbstractTemplateJobResourceReferenceHandler {
    private static final String VM = ".vm";
    private static final String QPROPERTY_PREFIX = "qproperty_";
    private static final String QPROPERTY_ARRAY_SUFFIX = "[]";
    private static final String CANCEL = "cancel";
    @Inject
    private JobExecutor executor;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private BeanManager beans;
    @Inject
    private CSRFToken csrf;

    private String[] getTemplates(Class<?> questionClass, String jobType, String prefix) {
        String className = questionClass.getName();
        String classSimpleName = questionClass.getSimpleName();
        String[] templates = new String[]{prefix + jobType + "/" + className + VM, prefix + jobType + "/" + classSimpleName + VM, prefix + jobType + VM, prefix + className + VM, prefix + classSimpleName + VM, prefix + "default.vm"};
        return templates;
    }

    @Override
    public void handle(ParentResourceReference reference) throws ResourceReferenceHandlerException {
        String token;
        HttpServletRequest httpRequest;
        List jobId = reference.getPathSegments();
        Job job = this.executor.getJob(jobId);
        if (job == null) {
            throw new ResourceReferenceHandlerException("Cannot find any running job with id " + String.valueOf(jobId));
        }
        Object question = job.getStatus().getQuestion();
        if (question == null) {
            throw new ResourceReferenceHandlerException("The job with id " + String.valueOf(jobId) + " does not have any question");
        }
        Request request = this.container.getRequest();
        String prefix = "question/";
        String contentType = "text/html; charset=utf-8";
        if (request instanceof ServletRequest && (httpRequest = ((ServletRequest)request).getHttpServletRequest()).getMethod().equals("POST") && this.csrf.isTokenValid(token = httpRequest.getParameter("form_token"))) {
            this.answer(httpRequest, job, jobId, question);
            prefix = "answer/";
            contentType = "application/json";
        }
        String jobType = job.getType();
        this.scriptContextManager.getCurrentScriptContext().setAttribute("job", job, 100);
        Object[] templates = this.getTemplates(question.getClass(), jobType, prefix);
        if (!this.tryTemplates(contentType, (String[])templates)) {
            throw new ResourceReferenceHandlerException("Cannot find any template for the job with id" + String.valueOf(jobId) + " (" + Arrays.toString(templates) + ")");
        }
    }

    private boolean isIterable(PropertyDescriptor propertyDescriptor) {
        Type type = propertyDescriptor.getPropertyType();
        if (TypeUtils.isArrayType((Type)type)) {
            return true;
        }
        return TypeUtils.isAssignable((Type)type, Iterable.class);
    }

    private void answer(HttpServletRequest request, Job job, List<String> jobId, Object question) throws ResourceReferenceHandlerException {
        try {
            this.beans.populate(question, this.extractParameters(request, question));
        }
        catch (PropertyException e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to populate question object for job with id [%s]", jobId), (Throwable)e);
        }
        if (job.getStatus() instanceof CancelableJobStatus && Boolean.parseBoolean(request.getParameter(CANCEL))) {
            ((CancelableJobStatus)job.getStatus()).cancel();
        }
        job.getStatus().answered();
    }

    private Map<String, Object> extractParameters(HttpServletRequest request, Object question) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        BeanDescriptor descriptor = this.beans.getBeanDescriptor(question.getClass());
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(QPROPERTY_PREFIX) || entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            String parameterKey = ((String)entry.getKey()).substring(QPROPERTY_PREFIX.length());
            if (parameterKey.endsWith(QPROPERTY_ARRAY_SUFFIX)) {
                parameterKey = parameterKey.substring(0, parameterKey.length() - QPROPERTY_ARRAY_SUFFIX.length());
                parameters.put(parameterKey, entry.getValue());
                continue;
            }
            this.addValue(descriptor, parameterKey, parameters, (String[])entry.getValue());
        }
        return parameters;
    }

    private void addValue(BeanDescriptor descriptor, String parameterKey, Map<String, Object> parameters, String[] value) {
        PropertyDescriptor propertyDescriptor = descriptor.getProperty(parameterKey);
        if (propertyDescriptor != null) {
            if (this.isIterable(propertyDescriptor)) {
                parameters.put(parameterKey, value);
            } else {
                parameters.put(parameterKey, value[0]);
            }
        }
    }
}

