/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedspaces.parentchild;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.index.tree.internal.AbstractDocumentTreeNode;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.tree.TreeNode;

@Component
@Named(value="document/parentChildOnNestedSpaces")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTreeNode
extends AbstractDocumentTreeNode {
    @Inject
    @Named(value="childDocuments/parentChildOnNestedSpaces")
    private TreeNode childDocuments;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        this.childNodes.addTreeNode(this.childDocuments, nodeId -> true);
    }

    @Override
    protected EntityReference getParent(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        DocumentReference parentReference = document.getParentReference();
        if (parentReference != null && parentReference.getParent().equals((Object)documentReference.getParent())) {
            return parentReference;
        }
        return documentReference.getParent();
    }
}

