/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedspaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;

@Component
@Named(value="wiki/nestedSpaces")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiTreeNode
extends AbstractEntityTreeNode {
    public WikiTreeNode() {
        super("wiki");
    }

    public List<String> getChildren(String nodeId, int offset, int limit) {
        EntityReference wikiReference = this.resolve(nodeId);
        if (wikiReference != null && wikiReference.getType() == EntityType.WIKI) {
            try {
                return this.serialize(this.getChildren(new WikiReference(wikiReference), offset, limit));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    private List<? extends EntityReference> getChildren(WikiReference wikiReference, int offset, int limit) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        constraints.add("parent is null");
        if (!this.areHiddenEntitiesShown()) {
            constraints.add("hidden <> true");
        }
        String statement = StringUtils.join(Arrays.asList("select name from XWikiSpace", this.whereClause(constraints), "order by lower(name), name"), (char)' ');
        Query query = this.queryManager.createQuery(statement, "hql");
        query.setWiki(wikiReference.getName());
        query.setOffset(offset);
        query.setLimit(limit);
        ArrayList<SpaceReference> spaceReferences = new ArrayList<SpaceReference>();
        for (Object result : query.execute()) {
            String name = (String)result;
            spaceReferences.add(new SpaceReference(name, wikiReference));
        }
        return spaceReferences;
    }

    public int getChildCount(String nodeId) {
        EntityReference wikiReference = this.resolve(nodeId);
        if (wikiReference != null && wikiReference.getType() == EntityType.WIKI) {
            try {
                return this.getChildCount(new WikiReference(wikiReference));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    private int getChildCount(WikiReference wikiReference) throws QueryException {
        return this.getChildSpacesCount((EntityReference)wikiReference);
    }

    public String getParent(String nodeId) {
        return "farm:*";
    }
}

