/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages.pinned;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.internal.nestedpages.pinned.PinnedChildPagesManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.event.DocumentRenamingEvent;
import org.xwiki.refactoring.job.MoveRequest;

@Component
@Singleton
@Named(value="PinnedChildPagesListener")
public class PinnedChildPagesListener
extends AbstractLocalEventListener {
    private static final DocumentRenamingEvent DOCUMENT_RENAMING_EVENT = new DocumentRenamingEvent();
    @Inject
    private PinnedChildPagesManager pinnedChildPagesManager;
    @Inject
    private JobContext jobContext;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private ObservationContext observationContext;

    public PinnedChildPagesListener() {
        super("Pinned child pages listener", new Event[]{new DocumentDeletedEvent(), new DocumentRenamedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        if (event instanceof DocumentRenamedEvent) {
            DocumentRenamedEvent documentRenamedEvent = (DocumentRenamedEvent)event;
            this.onDocumentRenamed((DocumentReference)documentRenamedEvent.getSourceReference(), (DocumentReference)documentRenamedEvent.getTargetReference());
        } else if (event instanceof DocumentDeletedEvent && !this.observationContext.isIn((BeginEvent)DOCUMENT_RENAMING_EVENT)) {
            this.onDocumentDeleted(((XWikiDocument)source).getDocumentReference());
        }
    }

    private void onDocumentDeleted(DocumentReference documentReference) {
        EntityReference parentReference = this.pinnedChildPagesManager.getParent(documentReference);
        List<DocumentReference> pinnedChildPages = this.getMutablePinnedChildPages(parentReference);
        if (pinnedChildPages.remove(documentReference)) {
            this.pinnedChildPagesManager.setPinnedChildPages(parentReference, pinnedChildPages);
        }
    }

    private void onDocumentRenamed(DocumentReference oldReference, DocumentReference newReference) {
        if (this.isRenameOrMoveJobTarget(oldReference)) {
            EntityReference newParentReference;
            EntityReference oldParentReference = this.pinnedChildPagesManager.getParent(oldReference);
            if (Objects.equals(oldParentReference, newParentReference = this.pinnedChildPagesManager.getParent(newReference))) {
                List<DocumentReference> pinnedChildPages = this.getMutablePinnedChildPages(oldParentReference);
                int index = pinnedChildPages.indexOf(oldReference);
                if (index >= 0) {
                    pinnedChildPages.set(index, newReference);
                    this.pinnedChildPagesManager.setPinnedChildPages(oldParentReference, pinnedChildPages);
                }
            } else {
                this.onDocumentDeleted(oldReference);
            }
        }
    }

    private List<DocumentReference> getMutablePinnedChildPages(EntityReference parentReference) {
        return new LinkedList<DocumentReference>(this.pinnedChildPagesManager.getPinnedChildPages(parentReference));
    }

    private boolean isRenameOrMoveJobTarget(DocumentReference documentReference) {
        Request request;
        String currentJobType = this.getCurrentJobType();
        if (("refactoring/rename".equals(currentJobType) || "refactoring/move".equals(currentJobType)) && (request = this.jobContext.getCurrentJob().getRequest()) instanceof MoveRequest) {
            MoveRequest moveRequest = (MoveRequest)request;
            Collection movedEntities = moveRequest.getEntityReferences();
            return this.contains(movedEntities, (EntityReference)documentReference);
        }
        return false;
    }

    private String getCurrentJobType() {
        Job job = this.jobContext.getCurrentJob();
        return job != null ? job.getType() : null;
    }

    private boolean contains(Collection<EntityReference> entityReferences, EntityReference entityReference) {
        if (!entityReferences.contains(entityReference) && EntityType.DOCUMENT.equals((Object)entityReference.getType())) {
            String spaceHomePageName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
            return spaceHomePageName.equals(entityReference.getName()) && entityReferences.contains(entityReference.getParent());
        }
        return true;
    }
}

