/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.tree.CompositeTreeNodeGroup;
import org.xwiki.tree.TreeNode;

@Component
@Named(value="wiki")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiTreeNode
extends AbstractEntityTreeNode
implements Initializable {
    public static final String HINT = "wiki";
    @Inject
    protected CompositeTreeNodeGroup childNodes;
    @Inject
    @Named(value="pinnedChildPages")
    private TreeNode pinnedChildPages;
    @Inject
    @Named(value="childDocuments")
    private TreeNode childDocuments;

    public WikiTreeNode() {
        super(HINT);
    }

    public void initialize() throws InitializationException {
        this.childNodes.addTreeNode(this.pinnedChildPages, nodeId -> true);
        this.childNodes.addTreeNode(this.childDocuments, nodeId -> true);
    }

    public int getChildCount(String nodeId) {
        return this.withSameProperties((TreeNode)this.childNodes).getChildCount(nodeId);
    }

    public List<String> getChildren(String nodeId, int offset, int limit) {
        return this.withSameProperties((TreeNode)this.childNodes).getChildren(nodeId, offset, limit);
    }

    public String getParent(String nodeId) {
        return "farm:*";
    }
}

