/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.PageHierarchy;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

@Component
@Named(value="nestedpages")
@Singleton
public class NestedPagesPageHierarchy
implements PageHierarchy {
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;
    @Inject
    @Named(value="document")
    private QueryFilter documenFilter;
    @Inject
    @Named(value="hidden/document")
    private QueryFilter hiddenDocumentFilter;
    @Inject
    @Named(value="hidden/space")
    private QueryFilter hiddenSpaceFilter;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;

    @Override
    public PageHierarchy.ChildrenQuery getChildren(WikiReference wikiReference) {
        return new NestedPagesChildrenQuery((EntityReference)wikiReference);
    }

    @Override
    public PageHierarchy.ChildrenQuery getChildren(DocumentReference documentReference) {
        return new NestedPagesChildrenQuery((EntityReference)documentReference);
    }

    private class NestedPagesChildrenQuery
    extends PageHierarchy.AbstractChildrenQuery {
        NestedPagesChildrenQuery(EntityReference parentReference) {
            super(parentReference);
        }

        @Override
        public List<DocumentReference> getDocumentReferences() throws QueryException {
            if (this.canHaveChildren()) {
                return this.buildQuery(true).addFilter(NestedPagesPageHierarchy.this.documenFilter).execute();
            }
            return List.of();
        }

        @Override
        public int count() throws QueryException {
            if (this.canHaveChildren()) {
                Query query = this.buildQuery(false).addFilter(NestedPagesPageHierarchy.this.countFilter);
                return ((Long)query.execute().get(0)).intValue();
            }
            return 0;
        }

        private boolean canHaveChildren() {
            return this.parentReference.getType() == EntityType.WIKI || this.parentReference.getType() == EntityType.DOCUMENT && "WebHome".equals(this.parentReference.getName());
        }

        private Query buildQuery(boolean ordered) throws QueryException {
            Object statement = ", XWikiSpace AS space WHERE doc.space = space.reference AND doc.translation = 0";
            statement = this.parentReference.getType() == EntityType.WIKI ? (String)statement + " AND doc.name = 'WebHome' AND space.parent IS NULL" : (String)statement + " AND ((doc.name <> 'WebHome' AND doc.space = :parent) OR (doc.name = 'WebHome' AND space.parent = :parent))";
            if (StringUtils.isNotEmpty((CharSequence)this.text)) {
                statement = this.parentReference.getType() == EntityType.WIKI ? (String)statement + " AND LOWER(space.name) LIKE :text" : (String)statement + " AND ((doc.name <> 'WebHome' AND LOWER(doc.name) LIKE :text) OR (doc.name = 'WebHome' AND LOWER(space.name) LIKE :text))";
            }
            if (ordered) {
                statement = (String)statement + " ORDER BY doc.fullName";
            }
            Query query = NestedPagesPageHierarchy.this.queryManager.createQuery((String)statement, "hql");
            EntityReference spaceReference = this.parentReference.extractReference(EntityType.SPACE);
            if (spaceReference != null) {
                query = query.bindValue("parent", NestedPagesPageHierarchy.this.localEntityReferenceSerializer.serialize(spaceReference, new Object[0]));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.text)) {
                query = query.bindValue("text").anyChars().literal(this.text.toLowerCase()).anyChars().query();
            }
            if (this.offset > 0) {
                query = query.setOffset(this.offset);
            }
            if (this.limit > 0) {
                query = query.setLimit(this.limit);
            }
            String wiki = this.parentReference.extractReference(EntityType.WIKI).getName();
            query = query.setWiki(wiki);
            return query.addFilter(NestedPagesPageHierarchy.this.hiddenDocumentFilter).addFilter(NestedPagesPageHierarchy.this.hiddenSpaceFilter);
        }
    }
}

