/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.index.tree.internal.AbstractDocumentTreeNode;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.tree.TreeNode;

@Component
@Named(value="document")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTreeNode
extends AbstractDocumentTreeNode {
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="addDocument")
    private TreeNode addDocument;
    @Inject
    @Named(value="pinnedChildPages")
    private TreeNode pinnedChildPages;
    @Inject
    @Named(value="childDocuments")
    private TreeNode childDocuments;

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        this.childNodes.addTreeNode(this.addDocument, nodeId -> this.showAddDocument(this.resolve((String)nodeId)));
        this.childNodes.addTreeNode(this.pinnedChildPages, nodeId -> this.canHaveChildDocuments(this.resolve((String)nodeId)));
        this.childNodes.addTreeNode(this.childDocuments, nodeId -> this.canHaveChildDocuments(this.resolve((String)nodeId)));
    }

    @Override
    protected EntityReference getParent(DocumentReference documentReference) throws Exception {
        if (this.getDefaultDocumentName().equals(documentReference.getName())) {
            EntityReference parentReference = documentReference.getParent().getParent();
            if (parentReference.getType() == EntityType.SPACE) {
                return new DocumentReference(this.getDefaultDocumentName(), new SpaceReference(parentReference));
            }
            return parentReference;
        }
        return new DocumentReference(this.getDefaultDocumentName(), documentReference.getLastSpaceReference());
    }

    private boolean canHaveChildDocuments(EntityReference parentReference) {
        return parentReference != null && (parentReference.getType() == EntityType.DOCUMENT || parentReference.getType() == EntityType.WIKI) && this.getDefaultDocumentName().equals(parentReference.getName());
    }

    private boolean showAddDocument(EntityReference parentReference) {
        return Boolean.TRUE.equals(this.getProperties().get("showAddDocument")) && "reference".equals(this.getProperties().get("hierarchyMode")) && this.canHaveChildDocuments(parentReference) && this.authorization.hasAccess(Right.EDIT, parentReference.getParent());
    }
}

