/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractChildDocumentsTreeNodeGroup;
import org.xwiki.index.tree.internal.macro.DocumentSort;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.properties.converter.Converter;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="childDocuments")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ChildDocumentsTreeNodeGroup
extends AbstractChildDocumentsTreeNodeGroup {
    public static final String HINT = "childDocuments";
    private static final String FIELD_TITLE = "title";
    private static final String PARAMETER_LOCALE = "locale";
    private static final String PARAMETER_EXCLUDED_DOCUMENTS = "excludedDocuments";
    @Inject
    @Named(value="count")
    protected QueryFilter countQueryFilter;
    @Inject
    @Named(value="hidden/document")
    protected Provider<QueryFilter> hiddenDocumentQueryFilterProvider;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    @Named(value="topLevelPage/nestedPages")
    private QueryFilter topLevelPageFilter;
    @Inject
    @Named(value="childPage/nestedPages")
    private QueryFilter childPageFilter;
    @Inject
    @Named(value="hiddenPage/nestedPages")
    private QueryFilter hiddenPageFilter;
    @Inject
    @Named(value="excludedSpace/nestedPages")
    private QueryFilter excludedSpaceFilter;
    @Inject
    @Named(value="excludedDocument/nestedPages")
    private QueryFilter excludedDocumentFilter;
    @Inject
    @Named(value="documentReferenceResolver/nestedPages")
    private QueryFilter documentReferenceResolverFilter;
    @Inject
    private Converter<DocumentSort> documentSortConverter;

    public ChildDocumentsTreeNodeGroup() {
        super(HINT);
    }

    @Override
    protected List<DocumentReference> getChildDocuments(EntityReference parentReference, int offset, int limit) throws QueryException {
        EntityReference parentSpaceReference;
        Set<String> excludedSpaces;
        Query query = this.getChildDocumentsQuery(parentReference);
        query.setWiki(parentReference.extractReference(EntityType.WIKI).getName());
        query.setOffset(offset);
        query.setLimit(limit);
        if (parentReference.getType() == EntityType.WIKI) {
            query.addFilter(this.topLevelPageFilter);
        } else {
            query.addFilter(this.childPageFilter);
            query.bindValue("parent", this.localEntityReferenceSerializer.serialize(parentReference.getParent(), new Object[0]));
        }
        if (!this.areHiddenEntitiesShown()) {
            query.addFilter(this.hiddenPageFilter);
        }
        if (!(excludedSpaces = this.getExcludedSpaces((parentSpaceReference = parentReference.extractReference(EntityType.SPACE)) != null ? parentSpaceReference : parentReference)).isEmpty()) {
            query.bindValue("excludedSpaces", excludedSpaces);
            query.addFilter(this.excludedSpaceFilter);
        }
        return query.addFilter(this.documentReferenceResolverFilter).execute();
    }

    private Query getChildDocumentsQuery(EntityReference parentReference) throws QueryException {
        Query query;
        DocumentSort sort = (DocumentSort)this.documentSortConverter.convert(DocumentSort.class, (Object)this.getOrderBy());
        if (this.canHaveTerminalChildDocuments(parentReference)) {
            query = this.getChildDocumentsQueryOrderedBy("nestedPagesOrderedBy", sort);
            Set<String> excludedDocuments = this.getExcludedDocuments(parentReference.getParent());
            if (!excludedDocuments.isEmpty()) {
                query.bindValue(PARAMETER_EXCLUDED_DOCUMENTS, excludedDocuments);
                query.addFilter(this.excludedDocumentFilter);
            }
        } else {
            query = this.getNonTerminalChildDocumentsQuery(sort);
        }
        return query;
    }

    private Query getChildDocumentsQueryOrderedBy(String namedQueryPrefix, DocumentSort sort) throws QueryException {
        Object fieldName;
        Object object = fieldName = sort != null ? sort.getField() : null;
        if (fieldName == null) {
            fieldName = "name";
        }
        fieldName = ((String)fieldName).substring(0, 1).toUpperCase() + ((String)fieldName).substring(1);
        Query query = this.queryManager.getNamedQuery(namedQueryPrefix + (String)fieldName + this.getOrder(sort));
        if (FIELD_TITLE.equalsIgnoreCase((String)fieldName)) {
            query.bindValue(PARAMETER_LOCALE, (Object)this.localizationContext.getCurrentLocale().toString());
        }
        return query;
    }

    private String getOrder(DocumentSort sort) {
        return sort != null && Boolean.FALSE.equals(sort.isAscending()) ? "Desc" : "Asc";
    }

    private Query getNonTerminalChildDocumentsQuery(DocumentSort sort) throws QueryException {
        Query query;
        String fieldName;
        String order = this.getOrder(sort);
        String string = fieldName = sort != null ? sort.getField() : null;
        if (FIELD_TITLE.equals(fieldName)) {
            query = this.queryManager.getNamedQuery("nonTerminalPagesOrderedByTitle" + order);
            query.bindValue(PARAMETER_LOCALE, (Object)this.localizationContext.getCurrentLocale().toString());
        } else {
            StringBuilder statement = new StringBuilder("select space.reference, 0 as terminal from XWikiSpace space");
            if (fieldName != null && List.of("date", "creationDate").contains(fieldName)) {
                statement.append(" left outer join XWikiDocument doc on doc.space = space.reference");
                statement.append(" and doc.name = 'WebHome' and doc.translation = 0");
                statement.append(String.format(" order by doc.%s %s nulls last", fieldName, order.toLowerCase()));
            } else {
                statement.append(String.format(" order by lower(space.name) %1$s, space.name %1$s", order.toLowerCase()));
            }
            query = this.queryManager.createQuery(statement.toString(), "hql");
        }
        return query;
    }

    @Override
    protected int getChildDocumentsCount(EntityReference parentReference) throws QueryException {
        int count = this.getChildSpacesCount(parentReference);
        if (this.canHaveTerminalChildDocuments(parentReference)) {
            count += this.getChildTerminalPagesCount(new DocumentReference(parentReference));
        }
        return count;
    }

    @Override
    protected boolean canHaveChildDocuments(EntityReference parentReference) {
        return parentReference.getType() == EntityType.WIKI || parentReference.getType() == EntityType.DOCUMENT && this.getDefaultDocumentName().equals(parentReference.getName());
    }

    private boolean canHaveTerminalChildDocuments(EntityReference parentReference) {
        return parentReference.getType() == EntityType.DOCUMENT && this.areTerminalDocumentsShown();
    }

    private int getChildTerminalPagesCount(DocumentReference documentReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        constraints.add("doc.translation = 0");
        constraints.add("doc.space = :space");
        parameters.put("space", this.localEntityReferenceSerializer.serialize(documentReference.getParent(), new Object[0]));
        constraints.add("doc.name <> :defaultDocName");
        parameters.put("defaultDocName", this.getDefaultDocumentName());
        Set<String> excludedDocuments = this.getExcludedDocuments(documentReference.getParent());
        if (!excludedDocuments.isEmpty()) {
            constraints.add("doc.fullName not in (:excludedDocuments)");
            parameters.put(PARAMETER_EXCLUDED_DOCUMENTS, excludedDocuments);
        }
        Query query = this.queryManager.createQuery(this.whereClause(constraints), "hql");
        query.setWiki(documentReference.getWikiReference().getName());
        for (Map.Entry entry : parameters.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        query.addFilter(this.countQueryFilter);
        if (Boolean.TRUE.equals(this.getProperties().get("filterHiddenDocuments"))) {
            query.addFilter((QueryFilter)this.hiddenDocumentQueryFilterProvider.get());
        }
        return ((Long)query.execute().get(0)).intValue();
    }
}

