/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.tree.AbstractTreeNode;

@Component
@Named(value="objectsOfType")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ObjectsOfTypeTreeNode
extends AbstractTreeNode {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public List<String> getChildren(String nodeId, int offset, int limit) {
        DocumentReference[] parts = this.resolve(nodeId);
        if (parts != null) {
            try {
                ArrayList<String> children = new ArrayList<String>();
                for (ObjectReference objectReference : this.subList(this.getXObjectReferences(parts[0], parts[1]), offset, limit)) {
                    children.add("object:" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)objectReference, new Object[0]));
                }
                return children;
            }
            catch (Exception e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause is [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    public int getChildCount(String nodeId) {
        DocumentReference[] parts = this.resolve(nodeId);
        if (parts != null) {
            try {
                return this.getXObjectReferences(parts[0], parts[1]).size();
            }
            catch (Exception e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause is [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    public String getParent(String nodeId) {
        DocumentReference[] parts = this.resolve(nodeId);
        if (parts != null) {
            return "objects:" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)parts[0], new Object[0]);
        }
        return null;
    }

    private DocumentReference[] resolve(String nodeId) {
        String[] parts = StringUtils.split((String)nodeId, (String)":", (int)2);
        if (parts == null || parts.length != 2 || !"objectsOfType".equals(parts[0])) {
            return null;
        }
        int separatorIndex = parts[1].lastIndexOf(47);
        if (separatorIndex < 0) {
            return null;
        }
        String serializedDocRef = parts[1].substring(0, separatorIndex);
        String serializedClassRef = parts[1].substring(separatorIndex + 1);
        return new DocumentReference[]{this.currentDocumentReferenceResolver.resolve((Object)serializedDocRef, new Object[0]), this.currentDocumentReferenceResolver.resolve((Object)serializedClassRef, new Object[0])};
    }

    private List<ObjectReference> getXObjectReferences(DocumentReference documentReference, DocumentReference classReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        ArrayList<ObjectReference> objectReferences = new ArrayList<ObjectReference>();
        List objects = document.getXObjects(classReference);
        if (objects != null) {
            for (BaseObject object : objects) {
                if (object == null) continue;
                objectReferences.add((ObjectReference)object.getReference());
            }
        }
        return objectReferences;
    }
}

