/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="farm")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class FarmTreeNode
extends AbstractEntityTreeNode {
    public static final String HINT = "farm";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public FarmTreeNode() {
        super(HINT);
    }

    public List<String> getChildren(String nodeId, int offset, int limit) {
        return this.subList(this.getWikiDescriptors(), offset, limit).stream().map(wikiDescriptor -> "wiki:" + wikiDescriptor.getId()).collect(Collectors.toCollection(ArrayList::new));
    }

    public int getChildCount(String nodeId) {
        return this.getWikiDescriptors().size();
    }

    private List<WikiDescriptor> getWikiDescriptors() {
        try {
            return this.wikiDescriptorManager.getAll().stream().filter(wikiDescriptor -> !this.getExcludedWikis().contains(wikiDescriptor.getId())).collect(Collectors.toList());
        }
        catch (WikiManagerException e) {
            this.logger.warn("Failed to retrieve the list of wikis. Root cause [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }
}

