/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractDocumentRelatedTreeNode;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="attachments")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AttachmentsTreeNode
extends AbstractDocumentRelatedTreeNode {
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public AttachmentsTreeNode() {
        super("attachments");
    }

    @Override
    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception {
        ArrayList<String> children = new ArrayList<String>();
        if (offset == 0 && this.showAddAttachment(documentReference)) {
            children.add("addAttachment:" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]));
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        List attachments = document.getAttachmentList();
        for (XWikiAttachment attachment : this.subList(attachments, offset, limit)) {
            children.add(this.serialize((EntityReference)attachment.getReference()));
        }
        return children;
    }

    @Override
    protected int getChildCount(DocumentReference documentReference) throws Exception {
        int count = 0;
        if (this.showAddAttachment(documentReference)) {
            ++count;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        return count += document.getAttachmentList().size();
    }

    private boolean showAddAttachment(DocumentReference documentReference) {
        return Boolean.TRUE.equals(this.getProperties().get("showAddAttachment")) && this.authorization.hasAccess(Right.EDIT, (EntityReference)documentReference);
    }
}

