/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.index.tree.internal.AbstractDocumentRelatedTreeNode;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.tree.CompositeTreeNodeGroup;
import org.xwiki.tree.TreeNode;

public abstract class AbstractDocumentTreeNode
extends AbstractDocumentRelatedTreeNode
implements Initializable {
    @Inject
    protected CompositeTreeNodeGroup childNodes;
    @Inject
    @Named(value="translations")
    private TreeNode translations;
    @Inject
    @Named(value="attachments")
    private TreeNode attachments;
    @Inject
    @Named(value="classProperties")
    private TreeNode classProperties;
    @Inject
    @Named(value="objects")
    private TreeNode objects;

    protected AbstractDocumentTreeNode() {
        super("document");
    }

    public void initialize() throws InitializationException {
        this.childNodes.addTreeNode(this.translations, nodeId -> this.hasChild(this.translations, this.resolve((String)nodeId)));
        this.childNodes.addTreeNode(this.attachments, nodeId -> this.hasChild(this.attachments, this.resolve((String)nodeId)));
        this.childNodes.addTreeNode(this.classProperties, nodeId -> this.hasChild(this.classProperties, this.resolve((String)nodeId)));
        this.childNodes.addTreeNode(this.objects, nodeId -> this.hasChild(this.objects, this.resolve((String)nodeId)));
        this.childNodes.setIdGenerator(this::getPseudoChildNodeId);
    }

    @Override
    public int getChildCount(String nodeId) {
        return this.withSameProperties((TreeNode)this.childNodes).getChildCount(nodeId);
    }

    @Override
    public List<String> getChildren(String nodeId, int offset, int limit) {
        return this.withSameProperties((TreeNode)this.childNodes).getChildren(nodeId, offset, limit);
    }

    private boolean hasChild(TreeNode childNode, EntityReference parentReference) {
        return this.hasChild(childNode, (String)this.defaultEntityReferenceSerializer.serialize(parentReference, new Object[0]));
    }

    private boolean hasChild(TreeNode childNode, String serializedDocumentReference) {
        String showChild = "show" + StringUtils.capitalize((String)childNode.getType());
        if (Boolean.TRUE.equals(this.getProperties().get(showChild))) {
            String nodeId = childNode.getType() + ":" + serializedDocumentReference;
            return this.withSameProperties(childNode).getChildCount(nodeId) > 0;
        }
        return false;
    }

    private String getPseudoChildNodeId(String parentNodeId, String pseudoNodeType) {
        EntityReference parentReference = this.resolve(parentNodeId);
        return pseudoNodeType + ":" + (String)this.defaultEntityReferenceSerializer.serialize(parentReference, new Object[0]);
    }
}

