/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryException;
import org.xwiki.tree.TreeNodeGroup;

public abstract class AbstractChildDocumentsTreeNodeGroup
extends AbstractEntityTreeNode
implements TreeNodeGroup {
    protected AbstractChildDocumentsTreeNodeGroup(String type) {
        super(type);
    }

    public List<String> getChildren(String nodeId, int offset, int limit) {
        EntityReference parentReference = this.resolve(nodeId);
        if (parentReference != null && this.canHaveChildDocuments(parentReference)) {
            try {
                return this.serialize(this.getChildDocuments(parentReference, offset, limit));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    protected abstract List<DocumentReference> getChildDocuments(EntityReference var1, int var2, int var3) throws QueryException;

    public int getChildCount(String nodeId) {
        EntityReference parentReference = this.resolve(nodeId);
        if (parentReference != null && this.canHaveChildDocuments(parentReference)) {
            try {
                return this.getChildDocumentsCount(parentReference);
            }
            catch (QueryException e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    protected abstract int getChildDocumentsCount(EntityReference var1) throws QueryException;

    protected abstract boolean canHaveChildDocuments(EntityReference var1);
}

