/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.PersistentClass;
import org.xwiki.component.annotation.Component;
import org.xwiki.doc.tasks.XWikiDocumentIndexingTask;
import org.xwiki.index.internal.TasksStore;

@Component
@Singleton
@Named(value="R140300001XWIKI19571")
@Deprecated(since="14.8RC1")
public class R140300001XWIKI19571DataMigration
extends AbstractHibernateDataMigration {
    public static final String HINT = "R140300001XWIKI19571";
    @Inject
    private HibernateStore hibernateStore;
    @Inject
    private Provider<TasksStore> tasksStore;
    private List<XWikiDocumentIndexingTask> tasks = new ArrayList<XWikiDocumentIndexingTask>();

    public String getDescription() {
        return "Save the content of xwikidocumentindexingqueue, remove it, let Hibernate recreate it with a new schema and finally re-insert the saved content in xwikidocumentindexingqueue";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(140300001);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getPreHibernateLiquibaseChangeLog() throws DataMigrationException {
        SessionFactory sessionFactory = this.hibernateStore.getSessionFactory();
        try (SessionImplementor session = (SessionImplementor)sessionFactory.openSession();){
            String string;
            block16: {
                this.hibernateStore.setWiki((Session)session);
                JdbcConnectionAccess jdbcConnectionAccess = session.getJdbcConnectionAccess();
                Connection connection = jdbcConnectionAccess.obtainConnection();
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    PersistentClass persistentClass = this.hibernateStore.getConfigurationMetadata().getEntityBinding(XWikiDocumentIndexingTask.class.getName());
                    String tableName = this.hibernateStore.getAdapter().getTableName(persistentClass);
                    String changeSet = "";
                    if (this.exists(databaseMetaData, tableName)) {
                        this.saveTasks(session, persistentClass, tableName);
                        changeSet = String.format("<changeSet author=\"xwikiorg\" id=\"%s0\">\n  <dropTable tableName=\"%s\"/>\n</changeSet>\n\n", HINT, tableName);
                    }
                    string = changeSet;
                    if (connection == null) break block16;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                connection.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new DataMigrationException("Error while loading the existing tasks.", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Error while setting the current wiki in the hibernate session.", (Throwable)e);
        }
    }

    protected void hibernateMigrate() throws XWikiException {
        for (XWikiDocumentIndexingTask task : this.tasks) {
            ((TasksStore)((Object)this.tasksStore.get())).addTask(this.getXWikiContext().getWikiId(), task);
        }
        this.tasks.clear();
    }

    private boolean exists(DatabaseMetaData databaseMetaData, String tableName) throws SQLException {
        String databaseName = this.hibernateStore.getAdapter().getDatabaseFromWikiName();
        ResultSet resultSet = this.hibernateStore.getAdapter().isCatalog() ? databaseMetaData.getTables(databaseName, null, tableName, null) : databaseMetaData.getTables(null, databaseName, tableName, null);
        return resultSet.next();
    }

    private void saveTasks(SessionImplementor session, PersistentClass entity, String tableName) throws SQLException {
        String docIdColumnName = this.hibernateStore.getConfiguredColumnName(entity, "docId");
        String versionColumnName = this.hibernateStore.getConfiguredColumnName(entity, "version");
        String typeColumnName = this.hibernateStore.getConfiguredColumnName(entity, "type");
        String instanceIdColumnName = this.hibernateStore.getConfiguredColumnName(entity, "instanceId");
        String timestampColumnName = this.hibernateStore.getConfiguredColumnName(entity, "timestamp");
        String sql = String.format("select %s, %s, %s, %s, %s from %s", docIdColumnName, versionColumnName, typeColumnName, instanceIdColumnName, timestampColumnName, tableName);
        List resultList = session.createSQLQuery(sql).getResultList();
        for (Object[] resultSet : resultList) {
            XWikiDocumentIndexingTask task = new XWikiDocumentIndexingTask();
            task.setDocId(((Number)resultSet[0]).longValue());
            task.setVersion(this.cleanupVersion((String)resultSet[1]));
            task.setType((String)resultSet[2]);
            task.setInstanceId((String)resultSet[3]);
            task.setTimestamp((Date)((Timestamp)resultSet[4]));
            this.tasks.add(task);
        }
    }

    private String cleanupVersion(String version) {
        return Optional.ofNullable(version).orElse("").replace("-", "");
    }
}

