/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.internal.migration;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.migration.AbstractDocumentsMigration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.QueryException;

@Component
@Singleton
@Named(value="R140300000XWIKI19614")
@Deprecated(since="14.8RC1")
public class R140300000XWIKI19614DataMigration
extends AbstractDocumentsMigration {
    public static final String HINT = "R140300000XWIKI19614";

    public String getName() {
        return HINT;
    }

    public String getDescription() {
        return "Queue all the document of the wiki for links indexing.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(150700001);
    }

    protected String getTaskType() {
        return "links";
    }

    protected List<DocumentReference> selectDocuments() throws DataMigrationException {
        List<Object> documents;
        XWikiContext context = this.getXWikiContext();
        XWiki wiki = this.getXWikiContext().getWiki();
        if (context.getWiki().hasBacklinks(context)) {
            try {
                documents = wiki.getStore().getQueryManager().createQuery("SELECT doc.fullName, doc.language FROM XWikiDocument doc", "hql").setWiki(context.getWikiId()).execute().stream().flatMap(array -> {
                    String locale = Objects.toString(array[1], "");
                    return this.resolveDocumentReference(String.valueOf(array[0]), locale).stream();
                }).collect(Collectors.toList());
            }
            catch (QueryException e) {
                throw new DataMigrationException(String.format("Failed retrieve the list of all the documents for wiki [%s].", wiki.getName()), (Throwable)e);
            }
        } else {
            documents = List.of();
        }
        return documents;
    }

    protected void logBeforeQueuingTask(DocumentReference documentReference) {
    }

    protected void logBeforeQueuingTasks(List<DocumentReference> documents) {
        XWikiContext context = this.getXWikiContext();
        if (context.getWiki().hasBacklinks(context)) {
            super.logBeforeQueuingTasks(documents);
        } else {
            this.logger.info("Skipped because backlinks are not supported on [{}]", (Object)context.getWikiId());
        }
    }
}

