/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.plugin.image;

import com.xpn.xwiki.plugin.image.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultImageProcessor
implements ImageProcessor {
    @Override
    public Image readImage(InputStream inputStream) throws IOException {
        return ImageIO.read(inputStream);
    }

    @Override
    public void writeImage(RenderedImage image, String mimeType, float quality, OutputStream out) throws IOException {
        if ("image/jpeg".equals(mimeType)) {
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType(mimeType);
            if (iter.hasNext()) {
                writer = iter.next();
            }
            JPEGImageWriteParam iwp = new JPEGImageWriteParam(null);
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(image, null, null), iwp);
            ios.flush();
            writer.dispose();
            ios.close();
        } else {
            ImageIO.write(image, "png", out);
        }
    }

    @Override
    public RenderedImage scaleImage(Image image, int width, int height) {
        int imageType = this.getBestImageTypeFor(image);
        BufferedImage bufferedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (!graphics2D.drawImage(image, 0, 0, width, height, null)) {
            throw new RuntimeException("Failed to resize image.");
        }
        return bufferedImage;
    }

    @Override
    public boolean isMimeTypeSupported(String mimeType) {
        try {
            return Arrays.asList(ImageIO.getReaderMIMETypes()).contains(mimeType);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    protected int getBestImageTypeFor(Image image) {
        int imageType = 6;
        if (image instanceof BufferedImage && ((imageType = ((BufferedImage)image).getType()) == 13 || imageType == 12 || imageType == 0)) {
            imageType = 6;
        }
        return imageType;
    }
}

