/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;
import org.xwiki.rendering.internal.util.XWikiSyntaxEscaper;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="icon")
@Singleton
public class IconManagerScriptService
implements ScriptService {
    private static final String ERROR_KEY = "scriptservice.icon.error";
    @Inject
    private IconManager iconManager;
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private IconRenderer iconRenderer;
    @Inject
    private Execution execution;
    @Inject
    private XWikiSyntaxEscaper escaper;

    public String render(String iconName) {
        return String.format("{{displayIcon name=\"%s\"/}}", this.escapeXWiki21(iconName));
    }

    public String render(String iconName, String iconSetName) {
        return String.format("{{displayIcon name=\"%s\" iconSet=\"%s\"/}}", this.escapeXWiki21(iconName), this.escapeXWiki21(iconSetName));
    }

    public String render(String iconName, String iconSetName, boolean fallback) {
        return String.format("{{displayIcon name=\"%s\" iconSet=\"%s\" fallback=\"%b\"/}}", this.escapeXWiki21(iconName), this.escapeXWiki21(iconSetName), fallback);
    }

    private String escapeXWiki21(String value) {
        return this.escaper.escape(value, Syntax.XWIKI_2_1);
    }

    public String renderHTML(String iconName) {
        try {
            return this.iconManager.renderHTML(iconName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String renderHTML(String iconName, String iconSetName) {
        try {
            return this.iconManager.renderHTML(iconName, iconSetName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String renderHTML(String iconName, String iconSetName, boolean fallback) {
        try {
            return this.iconManager.renderHTML(iconName, iconSetName, fallback);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public void use() {
        try {
            IconSet iconSet = this.iconSetManager.getDefaultIconSet();
            this.use(iconSet.getName());
        }
        catch (IconException e) {
            this.setLastError(e);
        }
    }

    public void use(String iconSetName) {
        try {
            IconSet iconSet = this.iconSetManager.getIconSet(iconSetName);
            this.iconRenderer.use(iconSet);
        }
        catch (IconException e) {
            this.setLastError(e);
        }
    }

    public List<String> getIconSetNames() {
        try {
            return this.iconSetManager.getIconSetNames();
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public List<String> getIconNames() {
        try {
            return this.iconManager.getIconNames();
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public List<String> getIconNames(String iconSetName) {
        try {
            return this.iconManager.getIconNames(iconSetName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public String getCurrentIconSetName() {
        try {
            IconSet currentIconSet = this.iconSetManager.getCurrentIconSet();
            if (currentIconSet != null) {
                return currentIconSet.getName();
            }
        }
        catch (IconException e) {
            this.setLastError(e);
        }
        return null;
    }

    public Map<String, Object> getMetaData(String iconName) throws IconException {
        try {
            return this.iconManager.getMetaData(iconName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public Map<String, Object> getMetaData(String iconName, String iconSetName) throws IconException {
        try {
            return this.iconManager.getMetaData(iconName, iconSetName);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public Map<String, Object> getMetaData(String iconName, String iconSetName, boolean fallback) throws IconException {
        try {
            return this.iconManager.getMetaData(iconName, iconSetName, fallback);
        }
        catch (IconException e) {
            this.setLastError(e);
            return null;
        }
    }

    public IconException getLastError() {
        return (IconException)((Object)this.execution.getContext().getProperty(ERROR_KEY));
    }

    private void setLastError(IconException e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }
}

