/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.macro.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.internal.DocumentContextExecutor;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;
import org.xwiki.icon.macro.DisplayIconMacroParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.async.internal.AbstractExecutedContentMacro;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Named(value="displayIcon")
@Singleton
public class DisplayIconMacro
extends AbstractExecutedContentMacro<DisplayIconMacroParameters> {
    private static final String DESCRIPTION = "Display an icon.";
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private IconRenderer iconRenderer;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private ContextualAuthorizationManager contextualAuthorization;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentUserSerializer;
    @Inject
    private DocumentContextExecutor documentContextExecutor;

    public DisplayIconMacro() {
        super("Icon", DESCRIPTION, null, DisplayIconMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public List<Block> execute(DisplayIconMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List result;
        try {
            IconSet iconSet = this.getIconSet(parameters);
            if (iconSet == null) {
                result = List.of();
            } else {
                XDOM iconBlock = this.parseIcon(parameters, context, iconSet);
                BlockAsyncRendererConfiguration rendererConfiguration = this.createBlockAsyncRendererConfiguration(null, (Block)iconBlock, null, context);
                rendererConfiguration.setAsyncAllowed(false);
                rendererConfiguration.setCacheAllowed(false);
                if (iconSet.getSourceDocumentReference() != null) {
                    DocumentReference sourceDocumentReference = iconSet.getSourceDocumentReference();
                    DocumentModelBridge sourceDocument = this.documentAccessBridge.getDocumentInstance(sourceDocumentReference);
                    DocumentReference authorReference = (DocumentReference)this.documentUserSerializer.serialize(sourceDocument.getAuthors().getContentAuthor());
                    rendererConfiguration.setSecureReference(sourceDocumentReference, authorReference);
                    rendererConfiguration.useEntity((EntityReference)sourceDocumentReference);
                    String stringDocumentReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)iconSet.getSourceDocumentReference(), new Object[0]);
                    rendererConfiguration.setTransformationId(stringDocumentReference);
                    rendererConfiguration.setResricted(false);
                    result = (List)this.documentContextExecutor.call(() -> List.of(this.executor.execute(rendererConfiguration)), sourceDocument);
                } else {
                    result = List.of(this.executor.execute(rendererConfiguration));
                }
            }
        }
        catch (MacroExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed parsing and executing the icon.", (Throwable)e);
        }
        return result;
    }

    private XDOM parseIcon(DisplayIconMacroParameters parameters, MacroTransformationContext context, IconSet iconSet) throws IconException, MacroExecutionException {
        String iconContent = this.iconRenderer.render(parameters.getName(), iconSet);
        MetaData metaData = null;
        if (iconSet.getSourceDocumentReference() != null) {
            String stringReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)iconSet.getSourceDocumentReference(), new Object[0]);
            metaData = new MetaData(Map.of("source", stringReference));
        }
        XDOM iconXDOM = this.parser.parse(iconContent, Syntax.XWIKI_2_1, context, false, metaData, true);
        if (!context.isInline()) {
            ParagraphBlock wrapper = new ParagraphBlock(iconXDOM.getChildren());
            iconXDOM.setChildren(List.of(wrapper));
        }
        return iconXDOM;
    }

    private IconSet getIconSet(DisplayIconMacroParameters parameters) throws IconException, MacroExecutionException {
        IconSet iconSet = parameters.getIconSet() == null ? this.iconSetManager.getCurrentIconSet() : this.iconSetManager.getIconSet(parameters.getIconSet());
        if (iconSet != null && iconSet.getSourceDocumentReference() != null && !this.contextualAuthorization.hasAccess(Right.VIEW, (EntityReference)iconSet.getSourceDocumentReference())) {
            if (parameters.isFallback()) {
                iconSet = null;
            } else {
                throw new MacroExecutionException(String.format("Current user [%s] doesn't have view rights on the icon set's document [%s]", this.documentAccessBridge.getCurrentUserReference(), iconSet.getSourceDocumentReference()));
            }
        }
        if (parameters.isFallback() && (iconSet == null || !iconSet.hasIcon(parameters.getName()))) {
            iconSet = this.iconSetManager.getDefaultIconSet();
        }
        return iconSet;
    }

    public boolean isExecutionIsolated(DisplayIconMacroParameters parameters, String content) {
        return true;
    }
}

