/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.internal.DocumentContextExecutor;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorExecutor;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityContext;

@Component(roles={VelocityRenderer.class})
@Singleton
public class VelocityRenderer {
    private static final String NAMESPACE = "DefaultIconRenderer";
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private LoggerConfiguration loggerConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private AuthorExecutor authorExecutor;
    @Inject
    private DocumentContextExecutor documentContextExecutor;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentUserSerializer;

    public String render(String code, DocumentReference contextDocumentReference) throws IconException {
        boolean result;
        String namespace = "IconVelocityRenderer_" + Thread.currentThread().getId();
        StringWriter output = new StringWriter();
        VelocityEngine engine = null;
        try {
            DocumentReference authorReference;
            DocumentModelBridge sourceDocument;
            engine = this.velocityManager.getVelocityEngine();
            engine.startedUsingMacroNamespace(namespace);
            if (contextDocumentReference != null) {
                sourceDocument = this.documentAccessBridge.getDocumentInstance(contextDocumentReference);
                authorReference = (DocumentReference)this.documentUserSerializer.serialize(sourceDocument.getAuthors().getContentAuthor());
            } else {
                authorReference = null;
                sourceDocument = null;
            }
            XWikiVelocityContext context = new XWikiVelocityContext((Context)this.velocityManager.getVelocityContext(), this.loggerConfiguration.isDeprecatedLogEnabled());
            VelocityEngine finalEngine = engine;
            Callable<Boolean> callable = () -> VelocityRenderer.lambda$render$0(finalEngine, (VelocityContext)context, output, code);
            if (contextDocumentReference != null) {
                Callable<Boolean> innerCallable = callable;
                callable = () -> (Boolean)this.documentContextExecutor.call(() -> (Boolean)this.authorExecutor.call(innerCallable, authorReference, contextDocumentReference), sourceDocument);
            }
            result = callable.call();
        }
        catch (Exception e) {
            throw new IconException("Failed to render the icon.", (Throwable)e);
        }
        finally {
            if (engine != null) {
                engine.stoppedUsingMacroNamespace(namespace);
            }
        }
        if (result) {
            return output.toString();
        }
        throw new IconException("Failed to render the icon. See the Velocity runtime log.");
    }

    private static /* synthetic */ Boolean lambda$render$0(VelocityEngine finalEngine, VelocityContext context, StringWriter output, String code) throws Exception {
        return finalEngine.evaluate((Context)context, (Writer)output, NAMESPACE, code);
    }
}

