/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.Icon;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetLoader;
import org.xwiki.icon.IconType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultIconSetLoader
implements IconSetLoader {
    private static final String CSS_PROPERTY_NAME = "xwiki.iconset.css";
    private static final String SSX_PROPERTY_NAME = "xwiki.iconset.ssx";
    private static final String JSX_PROPERTY_NAME = "xwiki.iconset.jsx";
    private static final String RENDER_WIKI_PROPERTY_NAME = "xwiki.iconset.render.wiki";
    private static final String RENDER_HTML_PROPERTY_NAME = "xwiki.iconset.render.html";
    private static final String ICON_TYPE_PROPERTY_NAME = "xwiki.iconset.type";
    private static final String ICON_URL_PROPERTY_NAME = "xwiki.iconset.icon.url";
    private static final String ICON_CSS_CLASS_PROPERTY_NAME = "xwiki.iconset.icon.cssClass";
    private static final String ERROR_MSG = "Failed to load the IconSet [%s].";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> documentUserSerializer;

    public IconSet loadIconSet(DocumentReference iconSetReference) throws IconException {
        try {
            DocumentModelBridge doc = this.documentAccessBridge.getDocumentInstance(iconSetReference);
            DocumentReference contentAuthor = (DocumentReference)this.documentUserSerializer.serialize(doc.getAuthors().getContentAuthor());
            this.authorizationManager.checkAccess(Right.SCRIPT, EntityType.DOCUMENT, contentAuthor, iconSetReference);
            DocumentReference metadataAuthor = (DocumentReference)this.documentUserSerializer.serialize(doc.getAuthors().getEffectiveMetadataAuthor());
            this.authorizationManager.checkAccess(Right.SCRIPT, EntityType.DOCUMENT, metadataAuthor, iconSetReference);
            String content = doc.getContent();
            DocumentReference iconClassRef = new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), "IconThemesCode", "IconThemeClass");
            String name = (String)this.documentAccessBridge.getProperty(iconSetReference, iconClassRef, "name");
            IconSet result = this.loadIconSet(new StringReader(content), name);
            result.setSourceDocumentReference(iconSetReference);
            return result;
        }
        catch (Exception e) {
            throw new IconException(String.format(ERROR_MSG, iconSetReference), (Throwable)e);
        }
    }

    public IconSet loadIconSet(Reader input, String name) throws IconException {
        IconSet iconSet = new IconSet(name);
        Properties properties = new Properties();
        try {
            properties.load(input);
        }
        catch (IOException e) {
            throw new IconException(String.format(ERROR_MSG, name), (Throwable)e);
        }
        properties.stringPropertyNames().forEach(key -> this.setIconSetProperty(iconSet, (String)key, properties.getProperty((String)key)));
        return iconSet;
    }

    private void setIconSetProperty(IconSet iconSet, String key, String value) {
        if (CSS_PROPERTY_NAME.equals(key)) {
            iconSet.setCss(value);
        } else if (SSX_PROPERTY_NAME.equals(key)) {
            iconSet.setSsx(value);
        } else if (JSX_PROPERTY_NAME.equals(key)) {
            iconSet.setJsx(value);
        } else if (RENDER_WIKI_PROPERTY_NAME.equals(key)) {
            iconSet.setRenderWiki(value);
        } else if (RENDER_HTML_PROPERTY_NAME.equals(key)) {
            iconSet.setRenderHTML(value);
        } else if (ICON_TYPE_PROPERTY_NAME.equals(key)) {
            iconSet.setType(IconType.valueOf((String)value.toUpperCase()));
        } else if (ICON_URL_PROPERTY_NAME.equals(key)) {
            iconSet.setIconUrl(value);
        } else if (ICON_CSS_CLASS_PROPERTY_NAME.equals(key)) {
            iconSet.setIconCssClass(value);
        } else {
            Icon icon = new Icon();
            icon.setValue(value);
            iconSet.addIcon(key, icon);
        }
    }
}

