/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetCache;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultIconSetCache
implements IconSetCache,
Initializable {
    private static final String ICON_SET_CACHE_ID = "iconset";
    private static final String NAME_SUFFIX = "NAMED:";
    private static final String DOCUMENT_SUFFIX = "DOC:";
    @Inject
    private CacheManager cacheManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    private Cache<IconSet> cache;

    public void initialize() throws InitializationException {
        try {
            CacheConfiguration configuration = new CacheConfiguration(ICON_SET_CACHE_ID);
            CacheFactory cacheFactory = this.cacheManager.getCacheFactory();
            this.cache = cacheFactory.newCache(configuration);
        }
        catch (CacheException | ComponentLookupException e) {
            throw new InitializationException("Failed to initialize the IconSet Cache.", e);
        }
    }

    private String getCacheKey(String name, String wikiId) {
        return wikiId.length() + wikiId + "_" + name;
    }

    public IconSet get(String name) {
        return (IconSet)this.cache.get(this.getKeyFromName(name));
    }

    public IconSet get(String name, String wikiId) {
        return this.get(this.getCacheKey(name, wikiId));
    }

    public IconSet get(DocumentReference documentReference) {
        return (IconSet)this.cache.get(this.getKeyFromDocument(documentReference));
    }

    public void put(String name, IconSet iconSet) {
        this.cache.set(this.getKeyFromName(name), (Object)iconSet);
    }

    public void put(String name, String wikiId, IconSet iconSet) {
        this.put(this.getCacheKey(name, wikiId), iconSet);
    }

    public void put(DocumentReference documentReference, IconSet iconSet) {
        this.cache.set(this.getKeyFromDocument(documentReference), (Object)iconSet);
    }

    public void clear() {
        this.cache.removeAll();
    }

    public void clear(DocumentReference documentReference) {
        this.cache.remove(this.getKeyFromDocument(documentReference));
    }

    public void clear(String name) {
        this.cache.remove(this.getKeyFromName(name));
    }

    public void clear(String name, String wikiId) {
        this.clear(this.getCacheKey(name, wikiId));
    }

    private String getKeyFromName(String name) {
        return NAME_SUFFIX + name;
    }

    private String getKeyFromDocument(DocumentReference docRef) {
        return DOCUMENT_SUFFIX + (String)this.entityReferenceSerializer.serialize((EntityReference)docRef, new Object[0]);
    }
}

