/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.io.StringWriter;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.Icon;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.internal.VelocityRenderer;
import org.xwiki.skinx.SkinExtension;

@Component
@Singleton
public class DefaultIconRenderer
implements IconRenderer {
    @Inject
    @Named(value="ssx")
    private SkinExtension skinExtension;
    @Inject
    @Named(value="linkx")
    private SkinExtension linkExtension;
    @Inject
    @Named(value="jsx")
    private SkinExtension jsExtension;
    @Inject
    private VelocityRenderer velocityRenderer;

    public String render(String iconName, IconSet iconSet) throws IconException {
        return this.render(iconName, iconSet, iconSet.getRenderWiki());
    }

    public String renderHTML(String iconName, IconSet iconSet) throws IconException {
        return this.render(iconName, iconSet, iconSet.getRenderHTML());
    }

    public String render(String iconName, IconSet iconSet, String renderer) throws IconException {
        if (renderer == null || iconSet == null) {
            return "";
        }
        Icon icon = iconSet.getIcon(iconName);
        if (icon == null) {
            return "";
        }
        this.use(iconSet);
        StringWriter contentToParse = new StringWriter();
        contentToParse.write("#set($icon = \"");
        contentToParse.write(icon.getValue());
        contentToParse.write("\")\n");
        contentToParse.write(renderer);
        return this.velocityRenderer.render(contentToParse.toString(), iconSet.getSourceDocumentReference());
    }

    public void use(IconSet iconSet) throws IconException {
        if (iconSet == null) {
            throw new IconException("The icon set is null");
        }
        if (!StringUtils.isBlank((CharSequence)iconSet.getCss())) {
            this.activeCSS(iconSet);
        }
        if (!StringUtils.isBlank((CharSequence)iconSet.getSsx())) {
            this.activeSSX(iconSet);
        }
        if (!StringUtils.isBlank((CharSequence)iconSet.getJsx())) {
            this.activeJSX(iconSet);
        }
    }

    private void activeCSS(IconSet iconSet) throws IconException {
        String url = this.velocityRenderer.render(iconSet.getCss(), iconSet.getSourceDocumentReference());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("rel", "stylesheet");
        this.linkExtension.use(url, parameters);
    }

    private void activeSSX(IconSet iconSet) {
        this.skinExtension.use(iconSet.getSsx());
    }

    private void activeJSX(IconSet iconSet) {
        this.jsExtension.use(iconSet.getJsx());
    }
}

