/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.flavor.internal.job;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManager;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.internal.AbstractInstallPlanJob;
import org.xwiki.extension.job.internal.ExtensionPlanContext;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanTree;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.Version;
import org.xwiki.job.Job;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.platform.flavor.FlavorManager;
import org.xwiki.platform.flavor.FlavorQuery;
import org.xwiki.platform.flavor.internal.job.DefaultFlavorSearchStatus;
import org.xwiki.platform.flavor.job.FlavorSearchRequest;

@Component
@Named(value="searchflavors")
public class FlavorSearchJob
extends AbstractInstallPlanJob<FlavorSearchRequest> {
    public static final String JOBTYPE = "searchflavors";
    @Inject
    private FlavorManager flavorManager;
    @Inject
    private ExtensionManager extensionManager;
    private final List<Extension> foundFlavors = new CopyOnWriteArrayList<Extension>();
    private final Map<ExtensionDependency, Boolean> validatedExtensions = new HashMap<ExtensionDependency, Boolean>();

    public String getType() {
        return JOBTYPE;
    }

    public JobGroupPath getGroupPath() {
        return null;
    }

    protected DefaultFlavorSearchStatus createNewStatus(FlavorSearchRequest request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        return new DefaultFlavorSearchStatus(request, this.observationManager, this.loggerManager, this.foundFlavors, currentJobStatus);
    }

    private Extension tryInstallExtension(ExtensionId extensionId, String namespace) {
        DefaultExtensionPlanTree currentTree = new DefaultExtensionPlanTree();
        try {
            this.installExtension(extensionId, namespace, currentTree);
            this.extensionsCache.clear();
            return ((ExtensionPlanNode)currentTree.get(0)).getAction().getExtension();
        }
        catch (InstallException e) {
            this.logger.debug("Can't install extension [{}] on namespace [{}].", new Object[]{extensionId, namespace, e});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installMandatoryExtensionDependency(ExtensionDependency extensionDependency, String namespace, List<AbstractInstallPlanJob.ModifableExtensionPlanNode> parentBranch, ExtensionPlanContext extensionContext, Set<String> parents) throws InstallException, IncompatibleVersionConstraintException, ResolveException {
        Boolean valid = Boolean.FALSE;
        try {
            if (this.validatedExtensions.get(extensionDependency) == Boolean.TRUE && this.configuration.getRecomendedVersionConstraint(extensionDependency.getId()) == null) {
                super.installMandatoryExtensionDependency(extensionDependency, namespace, parentBranch, extensionContext, parents);
            }
            valid = Boolean.TRUE;
        }
        finally {
            this.validatedExtensions.put(extensionDependency, valid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        Collection<ExtensionId> knownFlavors = this.flavorManager.getKnownFlavors();
        Collection<String> knownInvalidFlavors = this.flavorManager.getKnownInvalidFlavors();
        IterableResult<Extension> flavors = this.flavorManager.searchFlavors(new FlavorQuery());
        this.progressManager.pushLevelProgress(knownFlavors.size() + flavors.getSize(), (Object)this);
        try {
            HashSet<String> doneFlavors = new HashSet<String>();
            doneFlavors.addAll(knownInvalidFlavors);
            String namespace = (String)((FlavorSearchRequest)this.getRequest()).getNamespaces().iterator().next();
            for (ExtensionId flavorId : knownFlavors) {
                this.progressManager.startStep((Object)this);
                this.validateKnownFlavor(flavorId, namespace);
                doneFlavors.add(flavorId.getId());
                this.progressManager.endStep((Object)this);
            }
            for (Extension flavor : flavors) {
                Extension validExtension;
                this.progressManager.startStep((Object)this);
                if (!doneFlavors.contains(flavor.getId().getId()) && (validExtension = this.findValidVersion(flavor.getId().getId(), namespace)) != null) {
                    this.foundFlavors.add(validExtension);
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void validateKnownFlavor(ExtensionId flavorId, String namespace) {
        if (flavorId.getVersion() != null) {
            try {
                Extension flavor = this.extensionManager.resolveExtension(flavorId);
                if (this.namespaceResolver.isAllowed(flavor.getAllowedNamespaces(), namespace)) {
                    this.foundFlavors.add(flavor);
                }
            }
            catch (ResolveException e) {
                this.logger.debug("Failed to resolve extension [{}]", (Object)flavorId, (Object)e);
            }
        } else {
            Extension flavor = this.findValidVersion(flavorId.getId(), namespace);
            if (flavor != null) {
                this.foundFlavors.add(flavor);
            }
        }
    }

    private NavigableSet<Version> getVersions(String flavorId) {
        TreeSet<Version> versionList = new TreeSet<Version>();
        try {
            IterableResult localVersions = this.localExtensionRepository.resolveVersions(flavorId, 0, -1);
            for (Version version : localVersions) {
                versionList.add(version);
            }
        }
        catch (ResolveException e) {
            this.logger.debug("Failed to resolve local versions for extension id [{}]", (Object)flavorId, (Object)e);
        }
        try {
            IterableResult remoteVersions = this.repositoryManager.resolveVersions(flavorId, 0, -1);
            for (Version version : remoteVersions) {
                versionList.add(version);
            }
        }
        catch (ResolveException e) {
            this.logger.debug("Failed to resolve remote versions for extension id [{}]", (Object)flavorId, (Object)e);
        }
        return versionList;
    }

    private Extension findValidVersion(String flavorId, String namespace) {
        NavigableSet<Version> versions = this.getVersions(flavorId);
        if (versions.isEmpty()) {
            this.logger.debug("Could not find any version for the flavor extension [{}]", (Object)flavorId);
            return null;
        }
        return this.findValidVersion(flavorId, namespace, versions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extension findValidVersion(String flavorId, String namespace, NavigableSet<Version> versions) {
        this.progressManager.pushLevelProgress(versions.size(), (Object)flavorId);
        try {
            for (Version version : versions.descendingSet()) {
                this.progressManager.startStep((Object)flavorId);
                Extension extension = this.tryInstallExtension(new ExtensionId(flavorId, version), namespace);
                this.progressManager.endStep((Object)flavorId);
                if (extension == null) continue;
                Extension extension2 = extension;
                return extension2;
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)flavorId);
        }
        return null;
    }
}

