/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.flavor.internal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.platform.flavor.FlavorManager;
import org.xwiki.platform.flavor.FlavorQuery;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultFlavorManager
implements FlavorManager {
    @Inject
    private ExtensionRepositoryManager extensionRepositoryManager;
    @Inject
    private LocalExtensionRepository localRepository;
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private CoreExtensionRepository coreRepository;
    @Inject
    private ConverterManager converter;
    @Inject
    private ConfigurationSource configurationSource;
    @Inject
    private Logger logger;

    @Override
    @Deprecated
    public IterableResult<Extension> getFlavors(FlavorQuery query) throws SearchException {
        return this.searchFlavors(query);
    }

    @Override
    public IterableResult<Extension> searchFlavors(FlavorQuery query) throws SearchException {
        IterableResult result = null;
        try {
            result = RepositoryUtils.appendSearchResults(result, (IterableResult)this.localRepository.search((ExtensionQuery)query));
        }
        catch (SearchException e) {
            this.logger.error("Failed to search in local repository", (Throwable)e);
        }
        result = RepositoryUtils.appendSearchResults((IterableResult)result, (IterableResult)this.extensionRepositoryManager.search((ExtensionQuery)query));
        return result;
    }

    private Collection<ExtensionId> getFlavors(String property) {
        LinkedHashSet<ExtensionId> flavors = new LinkedHashSet<ExtensionId>();
        List<String> ids = this.getEnvironmentPropertyList(property);
        if (!ids.isEmpty()) {
            flavors.addAll((Collection)this.converter.convert((Type)ExtensionId.TYPE_LIST, ids));
        }
        return flavors;
    }

    private List<String> getEnvironmentPropertyList(String property) {
        CoreExtension extension = this.coreRepository.getEnvironmentExtension();
        if (extension != null) {
            String listString = (String)extension.getProperty(property);
            return ExtensionUtils.importPropertyStringList((String)listString, (boolean)true);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ExtensionId> getKnownFlavors() {
        LinkedHashSet<ExtensionId> flavors = new LinkedHashSet<ExtensionId>();
        List<String> ids = this.getEnvironmentPropertyList("xwiki.extension.knownFlavors");
        if (!ids.isEmpty()) {
            flavors.addAll((Collection)this.converter.convert((Type)ExtensionId.TYPE_LIST, ids));
        }
        return flavors;
    }

    @Override
    public Collection<String> getKnownInvalidFlavors() {
        return this.getEnvironmentPropertyList("xwiki.extension.knownInvalidFlavors");
    }

    @Override
    public ExtensionId getFlavorOfWiki(String wikiId) {
        Namespace namespace = new Namespace("wiki", wikiId);
        InstalledExtension flavor = this.getFlavorExtension(namespace);
        if (flavor != null) {
            return flavor.getId();
        }
        return null;
    }

    @Override
    public InstalledExtension getFlavorExtension(Namespace namespace) {
        try {
            for (InstalledExtension extension : this.installedRepository.searchInstalledExtensions(namespace.serialize(), (ExtensionQuery)new FlavorQuery())) {
                if (extension.isDependency(namespace.serialize())) continue;
                return extension;
            }
        }
        catch (SearchException searchException) {
            // empty catch block
        }
        for (String oldFlavor : this.getExtensionsConsideredAsFlavors()) {
            InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(oldFlavor, namespace.serialize());
            if (installedExtension == null) continue;
            return installedExtension;
        }
        return null;
    }

    private Collection<String> getExtensionsConsideredAsFlavors() {
        return (Collection)this.configurationSource.getProperty("extension.oldflavors", Collections.emptyList());
    }
}

