/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.output;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.FileOutputTarget;
import org.xwiki.filter.output.OutputStreamOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarPackage;

public class XARWikiWriter
implements Closeable {
    private final String name;
    private final XAROutputProperties xarProperties;
    private final ZipArchiveOutputStream zipStream;
    private XarPackage xarPackage;

    public XARWikiWriter(String name, XAROutputProperties xarProperties) throws FilterException {
        block4: {
            this.xarPackage = new XarPackage();
            this.name = name;
            this.xarProperties = xarProperties;
            this.xarPackage = new XarPackage();
            this.xarPackage.setPackageName(this.name);
            this.xarPackage.setPackageDescription(xarProperties.getPackageDescription());
            this.xarPackage.setPackageLicense(xarProperties.getPackageLicense());
            this.xarPackage.setPackageAuthor(xarProperties.getPackageAuthor());
            this.xarPackage.setPackageVersion(xarProperties.getPackageVersion());
            this.xarPackage.setPackageBackupPack(xarProperties.isPackageBackupPack());
            this.xarPackage.setPackagePreserveVersion(xarProperties.isPreserveVersion());
            this.xarPackage.setPackageExtensionId(xarProperties.getPackageExtensionId());
            OutputTarget target = this.xarProperties.getTarget();
            try {
                if (target instanceof FileOutputTarget && ((FileOutputTarget)target).getFile().isDirectory()) {
                    this.zipStream = new ZipArchiveOutputStream(new File(((FileOutputTarget)target).getFile(), name + ".xar"));
                    break block4;
                }
                if (target instanceof OutputStreamOutputTarget) {
                    this.zipStream = new ZipArchiveOutputStream((OutputStream)new CloseShieldOutputStream(((OutputStreamOutputTarget)target).getOutputStream()));
                    break block4;
                }
                throw new FilterException(String.format("Unsupported output target [%s]. Only [%s] is supported", target, OutputStreamOutputTarget.class));
            }
            catch (IOException e) {
                throw new FilterException("Failed to create zip output stream", (Throwable)e);
            }
        }
        this.zipStream.setEncoding("UTF8");
        this.zipStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
    }

    public String getName() {
        return this.name;
    }

    private String escapeXARPath(String pathElement) {
        return pathElement.replace("%", "%25").replace("/", "%2F").replace("\\", "%5C");
    }

    private void addSpacePath(StringBuilder path, EntityReference spaceReference) {
        EntityReference parent = spaceReference.getParent();
        if (parent != null && parent.getType() == EntityType.SPACE) {
            this.addSpacePath(path, parent);
        }
        path.append(this.escapeXARPath(spaceReference.getName())).append('/');
    }

    public OutputStream newEntry(LocalDocumentReference reference) throws FilterException {
        StringBuilder path = new StringBuilder();
        this.addSpacePath(path, reference.getParent());
        path.append(this.escapeXARPath(reference.getName()));
        if (reference.getLocale() != null && !reference.getLocale().equals(Locale.ROOT)) {
            path.append('.');
            path.append(reference.getLocale());
        }
        path.append(".xml");
        String entryName = path.toString();
        ZipArchiveEntry zipentry = new ZipArchiveEntry(entryName);
        try {
            this.zipStream.putArchiveEntry(zipentry);
        }
        catch (IOException e) {
            throw new FilterException("Failed to add a new zip entry for [" + String.valueOf(path) + "]", (Throwable)e);
        }
        this.xarPackage.addEntry(reference, entryName);
        return this.zipStream;
    }

    public void closeEntry() throws FilterException {
        try {
            this.zipStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new FilterException("Failed to close zip archive entry", (Throwable)e);
        }
    }

    private void writePackage() throws FilterException {
        try {
            this.xarPackage.write(this.zipStream, this.xarProperties.getEncoding());
        }
        catch (Exception e) {
            throw new FilterException("Failed to write package.xml entry", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writePackage();
        }
        catch (FilterException e) {
            throw new IOException("Failed to write package", e);
        }
        this.zipStream.close();
    }
}

