/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.output;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.filter.output.AbstractBeanOutputFilterStream;
import org.xwiki.filter.output.WriterOutputTarget;
import org.xwiki.filter.xar.internal.XARFilter;
import org.xwiki.filter.xar.internal.output.XARWikiWriter;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.filter.xml.internal.output.FilterStreamXMLStreamWriter;
import org.xwiki.filter.xml.output.ResultOutputTarget;
import org.xwiki.filter.xml.output.XMLOutputProperties;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.xar.internal.XarObjectPropertySerializerManager;

@Component(hints={"xwiki+xar/1.6", "xwiki+xar/1.5", "xwiki+xar/1.4", "xwiki+xar/1.3", "xwiki+xar/1.2", "xwiki+xar/1.1"})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XAROutputFilterStream
extends AbstractBeanOutputFilterStream<XAROutputProperties>
implements XARFilter {
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private EntityReferenceSerializer<String> defaultSerializer;
    @Inject
    private XarObjectPropertySerializerManager propertySerializerManager;
    private XARWikiWriter wikiWriter;
    private EntityReference currentSpaceReference;
    private String currentDocument;
    private FilterEventParameters currentDocumentParameters;
    private LocalDocumentReference currentDocumentReference;
    private String currentDocumentVersion;
    private String currentObjectClass;
    private FilterStreamXMLStreamWriter writer;
    private Map<String, String> currentObjectProperties;
    private static final int ATTACHMENT_BUFFER_CHUNK_SIZE = 4095;

    public void close() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (FilterException e) {
                throw new IOException("Failed to close XML writer", e);
            }
        }
        if (this.wikiWriter != null) {
            this.wikiWriter.close();
            this.wikiWriter = null;
        }
        ((XAROutputProperties)((Object)this.properties)).getTarget().close();
    }

    private String toString(Object obj) {
        return Objects.toString(obj, null);
    }

    private String toString(Date date) {
        return date != null ? String.valueOf(date.getTime()) : null;
    }

    private String toString(Syntax syntax) {
        return syntax != null ? syntax.toIdString() : null;
    }

    private String toString(EntityReference reference) {
        return (String)this.defaultSerializer.serialize(reference, new Object[0]);
    }

    private void writeStringElement(String pkey, String elementName, FilterEventParameters parameters) throws FilterException {
        if (parameters.containsKey((Object)pkey)) {
            this.writer.writeElement(elementName, (String)parameters.get((Object)pkey));
        }
    }

    private void writeDateElement(String pkey, String elementName, FilterEventParameters parameters) throws FilterException {
        if (parameters.containsKey((Object)pkey)) {
            this.writer.writeElement(elementName, this.toString((Date)parameters.get((Object)pkey)));
        }
    }

    public void beginWikiFarm(FilterEventParameters parameters) throws FilterException {
    }

    public void endWikiFarm(FilterEventParameters parameters) throws FilterException {
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws FilterException {
        this.wikiWriter = new XARWikiWriter(((XAROutputProperties)((Object)this.properties)).getPackageName() != null ? ((XAROutputProperties)((Object)this.properties)).getPackageName() : name, (XAROutputProperties)((Object)this.properties));
    }

    public void endWiki(String name, FilterEventParameters parameters) throws FilterException {
        try {
            this.wikiWriter.close();
        }
        catch (IOException e) {
            throw new FilterException("Failed to close XAR writer", (Throwable)e);
        }
        this.wikiWriter = null;
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentSpaceReference = this.currentSpaceReference == null ? new EntityReference(name, EntityType.SPACE) : new EntityReference(name, EntityType.SPACE, this.currentSpaceReference);
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) throws FilterException {
        this.currentSpaceReference = this.currentSpaceReference.getParent();
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentDocument = name;
        this.currentDocumentParameters = parameters;
        this.currentDocumentReference = new LocalDocumentReference(this.currentDocument, this.currentSpaceReference);
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws FilterException {
        this.currentDocument = null;
        this.currentDocumentReference = null;
        this.currentDocumentParameters = null;
    }

    private boolean isTargetTextualContent() {
        return ((XAROutputProperties)((Object)this.properties)).getTarget() instanceof WriterOutputTarget || ((XAROutputProperties)((Object)this.properties)).getTarget() instanceof ResultOutputTarget;
    }

    private void checkXMLWriter() throws FilterException {
        if (this.writer == null) {
            this.writer = new FilterStreamXMLStreamWriter((XMLOutputProperties)this.properties, true);
        }
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
        if (this.writer == null) {
            if (this.wikiWriter == null && (((XAROutputProperties)((Object)this.properties)).isForceDocument() || this.isTargetTextualContent())) {
                this.checkXMLWriter();
            } else {
                if (this.wikiWriter == null) {
                    this.wikiWriter = new XARWikiWriter(((XAROutputProperties)((Object)this.properties)).getPackageName() != null ? ((XAROutputProperties)((Object)this.properties)).getPackageName() : "package", (XAROutputProperties)((Object)this.properties));
                }
                this.writer = new FilterStreamXMLStreamWriter(this.wikiWriter.newEntry(new LocalDocumentReference((EntityReference)this.currentDocumentReference, locale)), ((XAROutputProperties)((Object)this.properties)).getEncoding(), ((XAROutputProperties)((Object)this.properties)).isFormat(), true);
            }
        }
        this.writer.writeStartDocument(((XAROutputProperties)((Object)this.properties)).getEncoding(), "1.1");
        this.writer.writeStartElement("xwikidoc");
        this.writer.writeAttribute("version", "1.6");
        this.writer.writeAttribute("reference", (String)this.localSerializer.serialize((EntityReference)this.currentDocumentReference, new Object[0]));
        this.writer.writeAttribute("locale", this.toString(locale));
        if (this.currentDocumentReference.getParent().getParent() == null) {
            this.writer.writeElement("web", this.currentDocumentReference.getParent().getName());
        } else {
            this.writer.writeElement("web", (String)this.defaultSerializer.serialize(this.currentDocumentReference.getParent(), new Object[0]));
        }
        this.writer.writeElement("name", this.currentDocumentReference.getName());
        this.writer.writeElement("language", this.toString(locale));
        this.writer.writeElement("defaultLanguage", this.toString(this.currentDocumentParameters.get((Object)"locale")));
        this.writer.writeElement("translation", locale != null && !Locale.ROOT.equals(locale) ? "1" : "0");
        if (parameters.containsKey((Object)"creation_author")) {
            this.writer.writeElement("creator", (String)parameters.get((Object)"creation_author"));
        }
        if (parameters.containsKey((Object)"creation_date")) {
            this.writer.writeElement("creationDate", this.toString((Date)parameters.get((Object)"creation_date")));
        }
        if (((XAROutputProperties)((Object)this.properties)).isPreserveVersion() && parameters.containsKey((Object)"xwiki_jrcsrevisions")) {
            this.writer.writeElement("versions", (String)parameters.get((Object)"xwiki_jrcsrevisions"));
        }
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws FilterException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
        if (this.wikiWriter != null) {
            this.wikiWriter.closeEntry();
        }
        this.writer = null;
    }

    public void beginWikiDocumentRevision(String revision, FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        this.currentDocumentVersion = revision;
        try {
            if (parameters.containsKey((Object)"parent_reference")) {
                this.writer.writeElement("parent", this.toString((EntityReference)parameters.get((Object)"parent_reference")));
            }
            if (parameters.containsKey((Object)"revision_author")) {
                this.writer.writeElement("author", (String)parameters.get((Object)"revision_author"));
            }
            if (parameters.containsKey((Object)"revision_original_author")) {
                this.writer.writeElement("originalMetadataAuthor", (String)parameters.get((Object)"revision_original_author"));
            }
            if (parameters.containsKey((Object)"customclass")) {
                this.writer.writeElement("customClass", (String)parameters.get((Object)"customclass"));
            }
            if (parameters.containsKey((Object)"content_author")) {
                this.writer.writeElement("contentAuthor", (String)parameters.get((Object)"content_author"));
            }
            if (parameters.containsKey((Object)"revision_date")) {
                this.writer.writeElement("date", this.toString((Date)parameters.get((Object)"revision_date")));
            }
            if (parameters.containsKey((Object)"content_date")) {
                this.writer.writeElement("contentUpdateDate", this.toString((Date)parameters.get((Object)"content_date")));
            }
            this.writer.writeElement("version", this.currentDocumentVersion);
            if (parameters.containsKey((Object)"title")) {
                this.writer.writeElement("title", (String)parameters.get((Object)"title"));
            }
            if (parameters.containsKey((Object)"defaulttemplate")) {
                this.writer.writeElement("defaultTemplate", (String)parameters.get((Object)"defaulttemplate"));
            }
            if (parameters.containsKey((Object)"validationscript")) {
                this.writer.writeElement("validationScript", (String)parameters.get((Object)"validationscript"));
            }
            if (parameters.containsKey((Object)"revision_comment")) {
                this.writer.writeElement("comment", (String)parameters.get((Object)"revision_comment"));
            }
            if (parameters.containsKey((Object)"revision_minor")) {
                this.writer.writeElement("minorEdit", this.toString(parameters.get((Object)"revision_minor")));
            }
            if (parameters.containsKey((Object)"syntax")) {
                this.writer.writeElement("syntaxId", this.toString((Syntax)parameters.get((Object)"syntax")));
            }
            if (parameters.containsKey((Object)"hidden")) {
                this.writer.writeElement("hidden", this.toString(parameters.get((Object)"hidden")));
            }
            if (parameters.containsKey((Object)"enforce_required_rights")) {
                this.writer.writeElement("enforceRequiredRights", this.toString(parameters.get((Object)"enforce_required_rights")));
            }
            if (parameters.containsKey((Object)"content")) {
                this.writer.writeElement("content", (String)parameters.get((Object)"content"));
            }
            if (parameters.containsKey((Object)"content_html")) {
                this.writer.writeElement("renderedcontent", (String)parameters.get((Object)"content_html"));
            }
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write begin document [%s] with version [%s]", this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void endWikiDocumentRevision(String revision, FilterEventParameters parameters) throws FilterException {
        this.currentDocumentVersion = null;
    }

    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws FilterException {
        try {
            this.beginWikiDocumentAttachment(name, (InputSource)(content != null ? new DefaultInputStreamInputSource(content) : null), size, parameters);
            this.endWikiDocumentAttachment(name, null, size, parameters);
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write attachment [%s] from document [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void beginWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        try {
            this.writer.writeStartElement("attachment");
            this.writer.writeElement("filename", name);
            if (((XAROutputProperties)((Object)this.properties)).isPreserveVersion() && parameters.containsKey((Object)"xwiki_jrcsrevisions")) {
                this.writeStringElement("xwiki_jrcsrevisions", "versions", parameters);
            }
            this.writeStringElement("mimetype", "mimetype", parameters);
            this.writeStringElement("charset", "charset", parameters);
            this.writeStringElement("revision_author", "author", parameters);
            this.writeDateElement("revision_date", "date", parameters);
            this.writeStringElement("revision", "version", parameters);
            this.writeStringElement("revision_comment", "comment", parameters);
            this.writeContent(content, size);
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write attachment [%s] from document [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void endWikiDocumentAttachment(String name, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        try {
            this.writer.writeEndElement();
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write attachment [%s] from document [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void beginWikiAttachmentRevisions(FilterEventParameters parameters) throws FilterException {
        this.writer.writeStartElement("revisions");
    }

    public void endWikiAttachmentRevisions(FilterEventParameters parameters) throws FilterException {
        this.writer.writeEndElement();
    }

    public void beginWikiAttachmentRevision(String version, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        this.writer.writeStartElement("revision");
        this.writeStringElement("revision_author", "author", parameters);
        this.writeDateElement("revision_date", "date", parameters);
        this.writeStringElement("revision", "version", parameters);
        this.writeStringElement("revision_comment", "comment", parameters);
        String contentAlias = (String)parameters.get((Object)"revision_content_alias");
        if (contentAlias != null) {
            this.writer.writeElement("contentAlias", contentAlias);
        }
        this.writeContent(content, size, contentAlias);
    }

    public void endWikiAttachmentRevision(String version, InputSource content, Long size, FilterEventParameters parameters) throws FilterException {
        this.writer.writeEndElement();
    }

    private void writeContent(InputSource content, Long size) throws FilterException {
        this.writeContent(content, size, null);
    }

    private void writeContent(InputSource content, Long size, String contentAlias) throws FilterException {
        if (!(content == null || ((XAROutputProperties)((Object)this.properties)).isOptimized() && contentAlias != null)) {
            this.writeContent(content);
        } else if (size != null) {
            this.writer.writeElement("filesize", this.toString(size));
        }
    }

    private void writeContent(InputSource content) throws FilterException {
        this.writer.writeStartElement("content");
        long contentSize = 0L;
        try (InputSource source = content;){
            int readSize;
            InputStream stream = this.getInputStream(source);
            byte[] buffer = new byte[4095];
            do {
                try {
                    readSize = stream.read(buffer, 0, 4095);
                }
                catch (IOException e) {
                    throw new FilterException("Failed to read content stream", (Throwable)e);
                }
                if (readSize <= 0) continue;
                String chunk = readSize == 4095 ? Base64.encodeBase64String((byte[])buffer) : Base64.encodeBase64String((byte[])ArrayUtils.subarray((byte[])buffer, (int)0, (int)readSize));
                this.writer.writeCharacters(chunk);
                contentSize += (long)readSize;
            } while (readSize == 4095);
        }
        catch (IOException e) {
            throw new FilterException("Failed to close stream", (Throwable)e);
        }
        this.writer.writeEndElement();
        this.writer.writeElement("filesize", this.toString(contentSize));
    }

    private InputStream getInputStream(InputSource content) throws FilterException {
        if (content instanceof InputStreamInputSource) {
            try {
                return ((InputStreamInputSource)content).getInputStream();
            }
            catch (IOException e) {
                throw new FilterException("Failed to get the content input stream", (Throwable)e);
            }
        }
        throw new FilterException("Unsupported input source with class [" + String.valueOf(content.getClass()) + "]");
    }

    public void beginWikiClass(FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        try {
            this.writer.writeStartElement("class");
            if (parameters.containsKey((Object)"name")) {
                this.writer.writeElement("name", (String)parameters.get((Object)"name"));
            } else {
                this.writer.writeElement("name", this.currentObjectClass != null ? this.currentObjectClass : (String)this.localSerializer.serialize((EntityReference)this.currentDocumentReference, new Object[0]));
            }
            if (parameters.containsKey((Object)"customclass")) {
                this.writer.writeElement("customClass", (String)parameters.get((Object)"customclass"));
            }
            if (parameters.containsKey((Object)"custommapping")) {
                this.writer.writeElement("customMapping", (String)parameters.get((Object)"custommapping"));
            }
            if (parameters.containsKey((Object)"sheet_defaultview")) {
                this.writer.writeElement("defaultViewSheet", (String)parameters.get((Object)"sheet_defaultview"));
            }
            if (parameters.containsKey((Object)"sheet_defaultedit")) {
                this.writer.writeElement("defaultEditSheet", (String)parameters.get((Object)"sheet_defaultedit"));
            }
            if (parameters.containsKey((Object)"defaultspace")) {
                this.writer.writeElement("defaultWeb", (String)parameters.get((Object)"defaultspace"));
            }
            if (parameters.containsKey((Object)"namefield")) {
                this.writer.writeElement("nameField", (String)parameters.get((Object)"namefield"));
            }
            if (parameters.containsKey((Object)"validationscript")) {
                this.writer.writeElement("validationScript", (String)parameters.get((Object)"validationscript"));
            }
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write begin xclass [%s] with version [%s]", this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void endWikiClass(FilterEventParameters parameters) throws FilterException {
        try {
            this.writer.writeEndElement();
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write end xclass [%s] with version [%s]", this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void beginWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        try {
            this.writer.writeStartElement(name);
            if (this.currentObjectProperties != null) {
                this.currentObjectProperties.put(name, type);
            }
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write begin property [%s] from class [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void endWikiClassProperty(String name, String type, FilterEventParameters parameters) throws FilterException {
        try {
            this.writer.writeElement("classType", type);
            this.writer.writeEndElement();
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write end property [%s] from class [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void onWikiClassPropertyField(String name, String value, FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        try {
            this.writer.writeElement(name, value);
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write property field [%s:%s] from class [%s] with version [%s]", name, value, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void beginWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        try {
            this.writer.writeStartElement("object");
            this.currentObjectClass = (String)parameters.get((Object)"class_reference");
            if (parameters.containsKey((Object)"name")) {
                this.writer.writeElement("name", (String)parameters.get((Object)"name"));
            } else {
                this.writer.writeElement("name", (String)this.localSerializer.serialize((EntityReference)this.currentDocumentReference, new Object[0]));
            }
            this.writer.writeElement("number", this.toString(parameters.get((Object)"number")));
            this.writer.writeElement("className", this.currentObjectClass);
            if (parameters.containsKey((Object)"guid")) {
                this.writer.writeElement("guid", (String)parameters.get((Object)"guid"));
            }
            this.currentObjectProperties = new HashMap<String, String>();
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write begin xobject [%s] from document [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void endWikiObject(String name, FilterEventParameters parameters) throws FilterException {
        try {
            this.writer.writeEndElement();
            this.currentObjectClass = null;
            this.currentObjectProperties = null;
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write end xobject [%s] from document [%s] with version [%s]", name, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }

    public void onWikiObjectProperty(String name, Object value, FilterEventParameters parameters) throws FilterException {
        this.checkXMLWriter();
        try {
            this.writer.writeStartElement("property");
            this.writer.writeStartElement(name);
            String type = (String)parameters.get((Object)"type");
            if (type == null && this.currentObjectProperties != null) {
                type = this.currentObjectProperties.get(name);
            }
            try {
                this.propertySerializerManager.getPropertySerializer(type).write(this.writer.getWriter(), value);
            }
            catch (Exception e) {
                throw new FilterException("Failed to write property value", (Throwable)e);
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to write xobject property [%s:%s] from document [%s] with version [%s]", name, value, this.currentDocumentReference, this.currentDocumentVersion), (Throwable)e);
        }
    }
}

