/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.input;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.internal.XARFilterUtils;
import org.xwiki.filter.xar.internal.XARObjectModel;
import org.xwiki.filter.xar.internal.input.AbstractWikiObjectPropertyReader;
import org.xwiki.filter.xar.internal.input.ClassReader;
import org.xwiki.filter.xar.internal.input.XARInputFilter;
import org.xwiki.filter.xar.internal.input.XARXMLReader;

@Component
@Singleton
public class WikiObjectReader
extends AbstractWikiObjectPropertyReader
implements XARXMLReader<WikiObject> {
    @Inject
    private XARXMLReader<ClassReader.WikiClass> classReader;

    @Override
    public WikiObject read(XMLStreamReader xmlReader, XARInputProperties properties) throws XMLStreamException, FilterException {
        WikiObject wikiObject = new WikiObject();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            if (elementName.equals("class")) {
                wikiObject.wikiClass = this.classReader.read(xmlReader, properties);
            } else if (elementName.equals("property")) {
                wikiObject.properties.add(this.readObjectProperty(xmlReader, properties, wikiObject.wikiClass));
            } else {
                XARFilterUtils.EventParameter parameter = XARObjectModel.OBJECT_PARAMETERS.get(elementName);
                if (parameter != null) {
                    Object wsValue = this.convert(parameter.type, xmlReader.getElementText());
                    if (wsValue != null) {
                        wikiObject.parameters.put((Object)parameter.name, wsValue);
                    }
                } else {
                    this.unknownElement(xmlReader);
                }
            }
            xmlReader.nextTag();
        }
        return wikiObject;
    }

    public static class WikiObject {
        public ClassReader.WikiClass wikiClass;
        public FilterEventParameters parameters = new FilterEventParameters();
        private List<AbstractWikiObjectPropertyReader.WikiObjectProperty> properties = new ArrayList<AbstractWikiObjectPropertyReader.WikiObjectProperty>();

        public void send(XARInputFilter proxyFilter) throws FilterException {
            String name = null;
            if (this.parameters.containsKey((Object)"class_reference")) {
                StringBuilder nameBuilder = new StringBuilder(this.parameters.get((Object)"class_reference").toString());
                if (this.parameters.containsKey((Object)"number")) {
                    nameBuilder.append('[');
                    nameBuilder.append(this.parameters.get((Object)"number"));
                    nameBuilder.append(']');
                }
                name = nameBuilder.toString();
            }
            proxyFilter.beginWikiObject(name, this.parameters);
            if (this.wikiClass != null) {
                this.wikiClass.send(proxyFilter);
            }
            for (AbstractWikiObjectPropertyReader.WikiObjectProperty property : this.properties) {
                property.send(proxyFilter);
            }
            proxyFilter.endWikiObject(name, this.parameters);
        }
    }
}

