/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.internal.XARDocumentModel;
import org.xwiki.filter.xar.internal.XARFilterUtils;
import org.xwiki.filter.xar.internal.input.AbstractReader;
import org.xwiki.filter.xar.internal.input.AbstractWikiObjectPropertyReader;
import org.xwiki.filter.xar.internal.input.AttachmentReader;
import org.xwiki.filter.xar.internal.input.ClassPropertyReader;
import org.xwiki.filter.xar.internal.input.ClassReader;
import org.xwiki.filter.xar.internal.input.SkipEntityException;
import org.xwiki.filter.xar.internal.input.WikiObjectReader;
import org.xwiki.filter.xar.internal.input.XARInputFilter;
import org.xwiki.filter.xar.internal.input.XARXMLReader;
import org.xwiki.filter.xml.input.XMLInputProperties;
import org.xwiki.filter.xml.internal.input.XMLInputFilterStreamUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.xml.stax.StAXUtils;

@Component(roles={DocumentLocaleReader.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentLocaleReader
extends AbstractReader {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeResolver;
    @Inject
    private XARXMLReader<WikiObjectReader.WikiObject> objectReader;
    @Inject
    private XARXMLReader<AbstractWikiObjectPropertyReader.WikiObjectProperty> objectPropertyReader;
    @Inject
    private XARXMLReader<ClassReader.WikiClass> classReader;
    @Inject
    private XARXMLReader<ClassPropertyReader.WikiClassProperty> classPropertyReader;
    @Inject
    private XARXMLReader<AttachmentReader.WikiAttachment> attachmentReader;
    private XARInputProperties properties;
    private String currentLegacySpace;
    private String currentLegacyDocument;
    private EntityReference sentSpaceReference;
    private EntityReference currentSpaceReference;
    private EntityReference currentDocumentReference;
    private Locale currentDocumentLocale;
    private boolean localeFromLegacy = true;
    private String currentDocumentRevision;
    private FilterEventParameters currentDocumentParameters = new FilterEventParameters();
    private FilterEventParameters currentDocumentLocaleParameters = new FilterEventParameters();
    private FilterEventParameters currentDocumentRevisionParameters = new FilterEventParameters();
    private boolean sentBeginWikiDocument;
    private boolean sentBeginWikiDocumentLocale;
    private boolean sentBeginWikiDocumentRevision;
    private XARInputProperties.SourceType currentSourceType = XARInputProperties.SourceType.DOCUMENT;
    private ClassReader.WikiClass currentClass = new ClassReader.WikiClass();
    private Queue<WikiObjectReader.WikiObject> currentObjects = new LinkedList<WikiObjectReader.WikiObject>();
    private Queue<AttachmentReader.WikiAttachment> currentAttachments = new LinkedList<AttachmentReader.WikiAttachment>();

    public void setProperties(XARInputProperties properties) {
        this.properties = properties;
    }

    public EntityReference getSentSpaceReference() {
        return this.sentSpaceReference;
    }

    public EntityReference getCurrentSpaceReference() {
        return this.currentSpaceReference;
    }

    public EntityReference getCurrentDocumentReference() {
        return this.currentDocumentReference;
    }

    private void resetDocument() {
        this.currentSpaceReference = null;
        this.currentLegacySpace = null;
        this.currentDocumentReference = null;
        this.currentLegacyDocument = null;
        this.currentDocumentLocale = null;
        this.currentDocumentRevision = null;
        this.currentDocumentParameters = new FilterEventParameters();
        this.currentDocumentParameters.put((Object)"locale", (Object)Locale.ROOT);
        this.currentDocumentLocaleParameters = new FilterEventParameters();
        this.currentDocumentRevisionParameters = new FilterEventParameters();
        this.sentBeginWikiDocument = false;
        this.sentBeginWikiDocumentLocale = false;
        this.sentBeginWikiDocumentRevision = false;
        this.localeFromLegacy = true;
    }

    private void switchWikiSpace(XARInputFilter proxyFilter, boolean force) throws FilterException {
        if (this.canSendEndWikiSpace(force)) {
            this.sendEndWikiSpace(proxyFilter, force);
        }
        if (this.canSendBeginWikiSpace(force)) {
            this.sendBeginWikiSpace(proxyFilter, force);
        }
    }

    private boolean canSendBeginWikiSpace(boolean force) {
        return !(this.sentSpaceReference != null && this.sentSpaceReference.equals((Object)this.currentSpaceReference) || !force && this.properties.getEntities() != null);
    }

    private void sendBeginWikiSpace(XARInputFilter proxyFilter, boolean force) throws FilterException {
        int sentSize;
        int size = this.currentSpaceReference != null ? this.currentSpaceReference.size() : 0;
        int diff = size - (sentSize = this.sentSpaceReference != null ? this.sentSpaceReference.size() : 0);
        if (diff > 0) {
            List spaces = this.currentSpaceReference.getReversedReferenceChain();
            for (int i = spaces.size() - diff; i < spaces.size(); ++i) {
                proxyFilter.beginWikiSpace(((EntityReference)spaces.get(i)).getName(), FilterEventParameters.EMPTY);
                this.sentSpaceReference = new EntityReference(((EntityReference)spaces.get(i)).getName(), EntityType.SPACE, this.sentSpaceReference);
            }
        }
    }

    private boolean canSendEndWikiSpace(boolean force) {
        return this.sentSpaceReference != null && !this.sentSpaceReference.equals((Object)this.currentSpaceReference) && (force || this.properties.getEntities() == null);
    }

    private void sendEndWikiSpace(XARInputFilter proxyFilter, boolean force) throws FilterException {
        int i;
        List sentSpaces = this.sentSpaceReference.getReversedReferenceChain();
        List currentSpaces = this.currentSpaceReference.getReversedReferenceChain();
        for (i = 0; i < sentSpaces.size() && i < currentSpaces.size() && ((EntityReference)currentSpaces.get(i)).equals(sentSpaces.get(i)); ++i) {
        }
        if (i < sentSpaces.size()) {
            int diff = sentSpaces.size() - i;
            while (diff > 0) {
                proxyFilter.endWikiSpace(this.sentSpaceReference.getName(), FilterEventParameters.EMPTY);
                --diff;
                this.sentSpaceReference = this.sentSpaceReference.getParent();
            }
        }
    }

    private boolean canSendBeginWikiDocument(boolean force) {
        return this.sentSpaceReference != null && !this.sentBeginWikiDocument && (force || this.currentDocumentReference != null && this.currentDocumentParameters.size() == XARDocumentModel.DOCUMENT_PARAMETERS.size() && this.properties.getEntities() == null);
    }

    private void sendBeginWikiDocument(XARInputFilter proxyFilter, boolean force) throws FilterException {
        this.switchWikiSpace(proxyFilter, force);
        if (this.canSendBeginWikiDocument(force)) {
            this.switchWikiSpace(proxyFilter, true);
            proxyFilter.beginWikiDocument(this.currentDocumentReference.getName(), this.currentDocumentParameters);
            this.sentBeginWikiDocument = true;
        }
    }

    private void sendEndWikiDocument(XARInputFilter proxyFilter) throws FilterException {
        this.sendBeginWikiDocument(proxyFilter, true);
        this.sendEndWikiDocumentLocale(proxyFilter);
        proxyFilter.endWikiDocument(this.currentDocumentReference.getName(), this.currentDocumentParameters);
        this.sentBeginWikiDocument = false;
    }

    private boolean canSendBeginWikiDocumentLocale(boolean force) {
        return this.sentBeginWikiDocument && !this.sentBeginWikiDocumentLocale && (force || this.currentDocumentLocale != null && this.currentDocumentLocaleParameters.size() == XARDocumentModel.DOCUMENTLOCALE_PARAMETERS.size());
    }

    private void sendBeginWikiDocumentLocale(XARInputFilter proxyFilter, boolean force) throws FilterException {
        if (force || this.currentDocumentReference != null && this.currentDocumentLocale != null) {
            LocalDocumentReference reference = new LocalDocumentReference(this.currentDocumentReference, this.currentDocumentLocale);
            if (this.properties.getEntities() != null && !this.properties.getEntities().matches((EntityReference)reference)) {
                throw new SkipEntityException((EntityReference)reference);
            }
            this.sendBeginWikiDocument(proxyFilter, force);
            if (this.canSendBeginWikiDocumentLocale(force)) {
                if (!this.properties.isWithHistory()) {
                    this.currentDocumentLocaleParameters.remove((Object)"xwiki_jrcsrevisions");
                }
                proxyFilter.beginWikiDocumentLocale(this.currentDocumentLocale, this.currentDocumentLocaleParameters);
                this.sentBeginWikiDocumentLocale = true;
            }
        }
    }

    private void sendEndWikiDocumentLocale(XARInputFilter proxyFilter) throws FilterException {
        this.sendBeginWikiDocumentLocale(proxyFilter, true);
        this.sendEndWikiDocumentRevision(proxyFilter);
        proxyFilter.endWikiDocumentLocale(this.currentDocumentLocale, this.currentDocumentLocaleParameters);
        this.sentBeginWikiDocumentLocale = false;
    }

    private boolean canSendBeginWikiDocumentRevision(boolean force) {
        return this.sentBeginWikiDocumentLocale && !this.sentBeginWikiDocumentRevision && (force || this.currentDocumentRevision != null && this.currentDocumentRevisionParameters.size() == XARDocumentModel.DOCUMENTREVISION_PARAMETERS.size());
    }

    private void sendBeginWikiDocumentRevision(XARInputFilter proxyFilter, boolean force) throws FilterException {
        this.sendBeginWikiDocumentLocale(proxyFilter, force);
        if (this.canSendBeginWikiDocumentRevision(force)) {
            proxyFilter.beginWikiDocumentRevision(this.currentDocumentRevision, this.currentDocumentRevisionParameters);
            this.sentBeginWikiDocumentRevision = true;
        }
    }

    private void sendEndWikiDocumentRevision(XARInputFilter proxyFilter) throws FilterException {
        this.sendBeginWikiDocumentRevision(proxyFilter, true);
        proxyFilter.endWikiDocumentRevision(this.currentDocumentRevision, this.currentDocumentRevisionParameters);
        this.sentBeginWikiDocumentRevision = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Object filter, XARInputFilter proxyFilter) throws XMLStreamException, IOException, FilterException {
        XMLStreamReader xmlReader = XMLInputFilterStreamUtils.createXMLStreamReader((XMLInputProperties)this.properties);
        try {
            this.read(xmlReader, filter, proxyFilter);
        }
        finally {
            this.properties.getSource().close();
        }
    }

    public void read(InputStream stream, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        XMLStreamReader xmlReader = this.properties.getEncoding() != null ? XML_INPUT_FACTORY.createXMLStreamReader(stream, this.properties.getEncoding()) : XML_INPUT_FACTORY.createXMLStreamReader(stream);
        this.read(xmlReader, filter, proxyFilter);
    }

    public void read(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        this.resetDocument();
        xmlReader.nextTag();
        this.currentSourceType = this.properties.getSourceType();
        if (this.currentSourceType != null) {
            switch (this.currentSourceType) {
                case ATTACHMENT: {
                    this.readAttachment(xmlReader, filter, proxyFilter);
                    break;
                }
                case CLASS: {
                    this.readClass(xmlReader, filter, proxyFilter);
                    break;
                }
                case CLASSPROPERTY: {
                    this.readClassProperty(xmlReader, filter, proxyFilter);
                    break;
                }
                case OBJECT: {
                    this.readObject(xmlReader, filter, proxyFilter);
                    break;
                }
                case OBJECTPROPERTY: {
                    this.readObjectProperty(xmlReader, filter, proxyFilter);
                    break;
                }
                default: {
                    this.readDocument(xmlReader, filter, proxyFilter);
                    break;
                }
            }
        } else {
            this.readDocument(xmlReader, filter, proxyFilter);
        }
    }

    private void readDocument(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        String localeString;
        xmlReader.require(1, null, "xwikidoc");
        this.currentSourceType = XARInputProperties.SourceType.DOCUMENT;
        this.currentDocumentRevisionParameters.put((Object)"syntax", (Object)Syntax.XWIKI_1_0);
        this.currentDocumentRevisionParameters.put((Object)"hidden", (Object)false);
        String referenceString = xmlReader.getAttributeValue(null, "reference");
        if (StringUtils.isNotEmpty((CharSequence)referenceString)) {
            this.currentDocumentReference = this.relativeResolver.resolve((Object)referenceString, EntityType.DOCUMENT, new Object[0]);
            this.currentSpaceReference = this.currentDocumentReference.getParent();
            this.switchWikiSpace(proxyFilter, false);
        }
        if ((localeString = xmlReader.getAttributeValue(null, "locale")) != null) {
            this.currentDocumentLocale = this.toLocale(localeString);
            this.localeFromLegacy = false;
        }
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            if (elementName.equals("attachment")) {
                this.readAttachment(xmlReader, filter, proxyFilter);
            } else if (elementName.equals("object")) {
                this.readObject(xmlReader, filter, proxyFilter);
            } else if (elementName.equals("class")) {
                this.readClass(xmlReader, filter, proxyFilter);
            } else if ("web".equals(elementName)) {
                this.currentLegacySpace = xmlReader.getElementText();
                if (this.currentDocumentReference == null) {
                    if (this.currentLegacyDocument == null) {
                        this.currentSpaceReference = new EntityReference(this.currentLegacySpace, EntityType.SPACE);
                    } else {
                        this.currentDocumentReference = new LocalDocumentReference(this.currentLegacySpace, this.currentLegacyDocument);
                        this.currentSpaceReference = this.currentDocumentReference.getParent();
                    }
                    this.switchWikiSpace(proxyFilter, false);
                }
            } else if ("name".equals(elementName)) {
                this.currentLegacyDocument = xmlReader.getElementText();
                if (this.currentDocumentReference == null && this.currentLegacySpace != null) {
                    this.currentDocumentReference = new LocalDocumentReference(this.currentLegacySpace, this.currentLegacyDocument);
                    this.currentSpaceReference = this.currentDocumentReference.getParent();
                }
            } else if ("language".equals(elementName)) {
                if (this.localeFromLegacy) {
                    this.currentDocumentLocale = this.toLocale(xmlReader.getElementText());
                } else {
                    StAXUtils.skipElement((XMLStreamReader)xmlReader);
                }
            } else if ("version".equals(elementName)) {
                this.currentDocumentRevision = xmlReader.getElementText();
            } else {
                XARFilterUtils.EventParameter parameter = XARDocumentModel.DOCUMENT_PARAMETERS.get(elementName);
                if (parameter != null) {
                    wsValue = this.convert(parameter.type, xmlReader.getElementText());
                    if (wsValue != null) {
                        this.currentDocumentParameters.put((Object)parameter.name, wsValue);
                    }
                } else {
                    parameter = XARDocumentModel.DOCUMENTLOCALE_PARAMETERS.get(elementName);
                    if (parameter != null) {
                        wsValue = this.convert(parameter.type, xmlReader.getElementText());
                        if (wsValue != null) {
                            this.currentDocumentLocaleParameters.put((Object)parameter.name, wsValue);
                        }
                    } else {
                        parameter = XARDocumentModel.DOCUMENTREVISION_PARAMETERS.get(elementName);
                        if (parameter != null) {
                            Object objectValue = parameter.type == EntityReference.class ? this.relativeResolver.resolve((Object)xmlReader.getElementText(), EntityType.DOCUMENT, new Object[0]) : this.convert(parameter.type, xmlReader.getElementText());
                            if (objectValue != null) {
                                this.currentDocumentRevisionParameters.put((Object)parameter.name, objectValue);
                            }
                        } else if (!XARDocumentModel.DOCUMENT_SKIPPEDPARAMETERS.contains(elementName)) {
                            this.unknownElement(xmlReader);
                        } else {
                            StAXUtils.skipElement((XMLStreamReader)xmlReader);
                        }
                    }
                }
            }
            xmlReader.nextTag();
        }
        this.sendBeginWikiDocumentRevision(proxyFilter, true);
        this.sendWikiAttachments(proxyFilter);
        this.sendWikiClass(proxyFilter);
        this.sendWikiObjects(proxyFilter);
        this.sendEndWikiDocument(proxyFilter);
    }

    private void readObject(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        if (this.currentSourceType == XARInputProperties.SourceType.DOCUMENT) {
            this.sendBeginWikiDocumentRevision(proxyFilter, false);
        }
        WikiObjectReader.WikiObject wikiObject = this.objectReader.read(xmlReader, this.properties);
        if (this.currentSourceType != XARInputProperties.SourceType.DOCUMENT || this.sentBeginWikiDocumentRevision) {
            wikiObject.send(proxyFilter);
        } else {
            this.currentObjects.offer(wikiObject);
        }
    }

    private void readObjectProperty(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        this.objectPropertyReader.read(xmlReader, this.properties).send(proxyFilter);
    }

    private void readClass(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        if (this.currentSourceType == XARInputProperties.SourceType.DOCUMENT) {
            this.sendBeginWikiDocumentRevision(proxyFilter, false);
        }
        this.currentClass = this.classReader.read(xmlReader, this.properties);
        if (this.currentSourceType != XARInputProperties.SourceType.DOCUMENT || this.sentBeginWikiDocumentRevision) {
            this.sendWikiClass(proxyFilter);
        }
    }

    private void readClassProperty(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        this.classPropertyReader.read(xmlReader, this.properties).send(proxyFilter);
    }

    private void readAttachment(XMLStreamReader xmlReader, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, FilterException {
        if (this.currentSourceType == XARInputProperties.SourceType.DOCUMENT) {
            this.sendBeginWikiDocumentRevision(proxyFilter, false);
        }
        AttachmentReader.WikiAttachment wikiAttachment = this.attachmentReader.read(xmlReader, this.properties);
        if (this.currentSourceType != XARInputProperties.SourceType.DOCUMENT || this.sentBeginWikiDocumentRevision) {
            wikiAttachment.send(proxyFilter);
        } else {
            this.currentAttachments.offer(wikiAttachment);
        }
    }

    private void sendWikiClass(XARInputFilter proxyFilter) throws FilterException {
        if (this.currentClass != null && !this.currentClass.isEmpty()) {
            this.currentClass.send(proxyFilter);
            this.currentClass = null;
        }
    }

    private void sendWikiObjects(XARInputFilter proxyFilter) throws FilterException {
        while (!this.currentObjects.isEmpty()) {
            this.currentObjects.poll().send(proxyFilter);
        }
    }

    private void sendWikiAttachments(XARInputFilter proxyFilter) throws FilterException {
        while (!this.currentAttachments.isEmpty()) {
            this.currentAttachments.poll().send(proxyFilter);
        }
    }
}

