/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xar.internal.input;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.AbstractInputStreamInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.xar.input.XARInputProperties;
import org.xwiki.filter.xar.internal.XARAttachmentModel;
import org.xwiki.filter.xar.internal.XARFilterUtils;
import org.xwiki.filter.xar.internal.input.AbstractReader;
import org.xwiki.filter.xar.internal.input.XARInputFilter;
import org.xwiki.filter.xar.internal.input.XARXMLReader;
import org.xwiki.xml.stax.StAXUtils;

@Component
@Singleton
public class AttachmentReader
extends AbstractReader
implements XARXMLReader<WikiAttachment> {
    @Inject
    private Environment environment;

    @Override
    public WikiAttachment read(XMLStreamReader xmlReader, XARInputProperties properties) throws XMLStreamException, FilterException {
        WikiAttachment wikiAttachment = new WikiAttachment();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            XARFilterUtils.EventParameter parameter = XARAttachmentModel.ATTACHMENT_PARAMETERS.get(elementName);
            if (parameter != null) {
                Object wsValue = this.convert(parameter.type, xmlReader.getElementText());
                if (wsValue != null) {
                    wikiAttachment.parameters.put((Object)parameter.name, wsValue);
                }
            } else if ("filename".equals(elementName)) {
                wikiAttachment.name = xmlReader.getElementText();
            } else if ("filesize".equals(elementName)) {
                wikiAttachment.size = Long.valueOf(xmlReader.getElementText());
            } else if ("content".equals(elementName)) {
                this.readContent(xmlReader, wikiAttachment);
            } else if ("revisions".equals(elementName)) {
                if (properties.isWithHistory()) {
                    this.readRevisions(xmlReader, properties, wikiAttachment);
                } else {
                    StAXUtils.skipElement((XMLStreamReader)xmlReader);
                }
            } else {
                this.unknownElement(xmlReader);
            }
            xmlReader.nextTag();
        }
        return wikiAttachment;
    }

    private void readRevisions(XMLStreamReader xmlReader, XARInputProperties properties, WikiAttachment wikiAttachment) throws XMLStreamException, FilterException {
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            if ("revision".equals(elementName)) {
                wikiAttachment.revisions.add(this.readRevision(xmlReader, properties));
            }
            xmlReader.nextTag();
        }
    }

    private WikiAttachmentRevision readRevision(XMLStreamReader xmlReader, XARInputProperties properties) throws XMLStreamException, FilterException {
        WikiAttachmentRevision wikiAttachmentRevision = new WikiAttachmentRevision();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            XARFilterUtils.EventParameter parameter = XARAttachmentModel.ATTACHMENT_PARAMETERS.get(elementName);
            if (parameter != null) {
                Object wsValue = this.convert(parameter.type, xmlReader.getElementText());
                if (wsValue != null) {
                    wikiAttachmentRevision.parameters.put((Object)parameter.name, wsValue);
                }
            } else if ("revision".equals(elementName)) {
                wikiAttachmentRevision.version = xmlReader.getElementText();
            } else if ("filesize".equals(elementName)) {
                wikiAttachmentRevision.size = Long.valueOf(xmlReader.getElementText());
            } else if ("content".equals(elementName)) {
                this.readContent(xmlReader, wikiAttachmentRevision);
            } else {
                this.unknownElement(xmlReader);
            }
            xmlReader.nextTag();
        }
        return wikiAttachmentRevision;
    }

    private void readContent(XMLStreamReader xmlReader, AbstractContent content) throws XMLStreamException, FilterException {
        File temporaryFile;
        try {
            temporaryFile = File.createTempFile("xar/attachments/attachment", ".bin", this.environment.getTemporaryDirectory());
        }
        catch (IOException e) {
            throw new FilterException((Throwable)e);
        }
        content.content = new DeferredFileOutputStream(100000, temporaryFile);
        xmlReader.next();
        while (xmlReader.isCharacters()) {
            try {
                content.content.write(xmlReader.getText().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new FilterException((Throwable)e);
            }
            xmlReader.next();
        }
    }

    public static class WikiAttachment
    extends AbstractContent {
        public String name;
        public Long size;
        public List<WikiAttachmentRevision> revisions = new ArrayList<WikiAttachmentRevision>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(XARInputFilter proxyFilter) throws FilterException {
            if (this.content != null) {
                try {
                    if (this.revisions.isEmpty()) {
                        try (InputStream stream = this.openStream();){
                            proxyFilter.onWikiAttachment(this.name, stream, this.size, this.parameters);
                        }
                        catch (IOException e) {
                            throw new FilterException((Throwable)e);
                        }
                    }
                    proxyFilter.beginWikiDocumentAttachment(this.name, (InputSource)this, this.size, this.parameters);
                    if (!this.revisions.isEmpty()) {
                        proxyFilter.beginWikiAttachmentRevisions(FilterEventParameters.EMPTY);
                        for (WikiAttachmentRevision revision : this.revisions) {
                            revision.send(proxyFilter);
                        }
                        proxyFilter.endWikiAttachmentRevisions(FilterEventParameters.EMPTY);
                    }
                    proxyFilter.endWikiDocumentAttachment(this.name, (InputSource)this, this.size, this.parameters);
                }
                finally {
                    if (this.content.isInMemory()) {
                        this.content.getFile().delete();
                    }
                }
            } else {
                proxyFilter.onWikiAttachment(this.name, null, this.size, this.parameters);
            }
        }

        protected void finalize() throws Throwable {
            if (this.content != null && !this.content.isInMemory() && this.content.getFile() != null && this.content.getFile().exists()) {
                this.content.getFile().delete();
            }
            super.finalize();
        }
    }

    public static class AbstractContent
    extends AbstractInputStreamInputSource {
        public DeferredFileOutputStream content;
        public FilterEventParameters parameters = new FilterEventParameters();

        protected InputStream openStream() throws IOException {
            InputStream stream = this.content.isInMemory() ? new ByteArrayInputStream(this.content.getData()) : new FileInputStream(this.content.getFile());
            return new Base64InputStream(stream);
        }

        public void dispose() {
            File contentFile;
            if (this.content != null && (contentFile = this.content.getFile()) != null && contentFile.exists()) {
                contentFile.delete();
            }
        }
    }

    public static class WikiAttachmentRevision
    extends AbstractContent {
        public String version;
        public Long size;
        public FilterEventParameters parameters = new FilterEventParameters();

        public void send(XARInputFilter proxyFilter) throws FilterException {
            WikiAttachmentRevision inputSource = this.content != null ? this : null;
            try {
                proxyFilter.beginWikiAttachmentRevision(this.version, (InputSource)inputSource, this.size, this.parameters);
                proxyFilter.endWikiAttachmentRevision(this.version, (InputSource)inputSource, this.size, this.parameters);
            }
            finally {
                this.dispose();
            }
        }
    }
}

