/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.job.JobRequestContext;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterStreamFactory;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.job.FilterStreamConverterJobRequest;
import org.xwiki.filter.output.DefaultOutputStreamOutputTarget;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.output.OutputStreamOutputTarget;
import org.xwiki.filter.script.AbstractFilterScriptService;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.script.service.ScriptService;
import org.xwiki.script.service.ScriptServiceManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="filter")
@Singleton
public class FilterScriptService
extends AbstractFilterScriptService {
    public static final String ROLEHINT = "filter";
    @Inject
    private ScriptServiceManager scriptServiceManager;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="filter.converter")
    private Provider<Job> jobProvider;
    private Job lastJob;

    public ScriptService get(String id) {
        return this.scriptServiceManager.get("filter." + id);
    }

    public Job startConvert(FilterStreamType inputType, Map<String, Object> inputProperties, FilterStreamType outputType, Map<String, Object> outputProperties) {
        return this.startConvert(inputType, inputProperties, outputType, true, outputProperties);
    }

    public Job startConvert(FilterStreamType inputType, Map<String, Object> inputProperties, FilterStreamType outputType, boolean folded, Map<String, Object> outputProperties) {
        return this.convert(inputType, inputProperties, outputType, folded, outputProperties, true);
    }

    public Job convert(FilterStreamType inputType, Map<String, Object> inputProperties, FilterStreamType outputType, Map<String, Object> outputProperties) {
        return this.convert(inputType, inputProperties, outputType, true, outputProperties);
    }

    public Job convert(FilterStreamType inputType, Map<String, Object> inputProperties, FilterStreamType outputType, boolean folded, Map<String, Object> outputProperties) {
        return this.convert(inputType, inputProperties, outputType, folded, outputProperties, false);
    }

    private Job convert(FilterStreamType inputType, Map<String, Object> inputProperties, FilterStreamType outputType, boolean folded, Map<String, Object> outputProperties, boolean async) {
        this.resetError();
        this.lastJob = null;
        try {
            this.authorization.checkAccess(Right.PROGRAM);
            FilterStreamConverterJobRequest request = new FilterStreamConverterJobRequest(inputType, inputProperties, outputType, folded, outputProperties);
            if (async) {
                JobRequestContext.set((AbstractRequest)request, (XWikiContext)((XWikiContext)this.xcontextProvider.get()));
                this.lastJob = this.jobExecutor.execute("filter.converter", (Request)request);
            } else {
                this.lastJob = (Job)this.jobProvider.get();
                this.lastJob.initialize((Request)request);
                this.lastJob.run();
            }
        }
        catch (Exception e) {
            this.setError(e);
        }
        return this.lastJob;
    }

    public Job getCurrentJob() {
        return this.lastJob;
    }

    private Collection<FilterStreamType> getAvailableStreams(Type factoryType) {
        this.resetError();
        try {
            List descriptors = ((ComponentManager)this.componentManagerProvider.get()).getComponentDescriptorList(factoryType);
            ArrayList<FilterStreamType> types = new ArrayList<FilterStreamType>(descriptors.size());
            for (ComponentDescriptor descriptor : descriptors) {
                types.add(FilterStreamType.unserialize((String)descriptor.getRoleHint()));
            }
            Collections.sort(types);
            return types;
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public Collection<FilterStreamType> getAvailableInputStreams() {
        return this.getAvailableStreams((Type)((Object)InputFilterStreamFactory.class));
    }

    public Collection<FilterStreamType> getAvailableOutputStreams() {
        return this.getAvailableStreams((Type)((Object)OutputFilterStreamFactory.class));
    }

    private FilterStreamDescriptor getFilterStreamDescriptor(Type factoryType, FilterStreamType type) {
        this.resetError();
        try {
            return ((FilterStreamFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(factoryType, type.serialize())).getDescriptor();
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public FilterStreamDescriptor getInputFilterStreamDescriptor(FilterStreamType inputType) {
        return this.getFilterStreamDescriptor((Type)((Object)InputFilterStreamFactory.class), inputType);
    }

    public FilterStreamDescriptor getOutputFilterStreamDescriptor(FilterStreamType outputType) {
        return this.getFilterStreamDescriptor((Type)((Object)OutputFilterStreamFactory.class), outputType);
    }

    private <F extends FilterStreamFactory> F getInputFilterStreamFactory(Type factoryType, FilterStreamType inputType) {
        this.resetError();
        try {
            this.authorization.checkAccess(Right.PROGRAM);
            return (F)((FilterStreamFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(factoryType, inputType.serialize()));
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public InputFilterStreamFactory getInputFilterStreamFactory(FilterStreamType inputType) {
        return (InputFilterStreamFactory)this.getInputFilterStreamFactory((Type)((Object)InputFilterStreamFactory.class), inputType);
    }

    public OutputFilterStreamFactory getOutputFilterStreamFactory(FilterStreamType outputType) {
        return (OutputFilterStreamFactory)this.getInputFilterStreamFactory((Type)((Object)OutputFilterStreamFactory.class), outputType);
    }

    public OutputStreamOutputTarget createOutputStreamOutputTarget(OutputStream stream, boolean autoclose) {
        return new DefaultOutputStreamOutputTarget(stream, autoclose);
    }
}

