/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.output;

import org.xwiki.filter.instance.output.EntityInstanceOutputProperties;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyName;
import org.xwiki.rendering.syntax.Syntax;

public class DocumentInstanceOutputProperties
extends EntityInstanceOutputProperties {
    private EntityReference defaultReference;
    private Syntax defaultSyntax;
    private boolean previousDeleted = true;
    private boolean authorPreserved = true;
    private boolean stoppedWhenSaveFail = true;

    @PropertyName(value="Default reference")
    @PropertyDescription(value="The base reference to use to resolve reference from events")
    public EntityReference getDefaultReference() {
        return this.defaultReference;
    }

    public void setDefaultReference(EntityReference defaultReference) {
        this.defaultReference = defaultReference;
    }

    @PropertyName(value="Default syntax")
    @PropertyDescription(value="The default syntax if not is provided in events")
    public Syntax getDefaultSyntax() {
        return this.defaultSyntax;
    }

    public void setDefaultSyntax(Syntax defaultSyntax) {
        this.defaultSyntax = defaultSyntax;
    }

    @PropertyName(value="Delete existing document")
    @PropertyDescription(value="Indicate if existing document should be deleted before importing the new one")
    public boolean isPreviousDeleted() {
        return this.previousDeleted;
    }

    public void setPreviousDeleted(boolean previousDeleted) {
        this.previousDeleted = previousDeleted;
    }

    @PropertyName(value="Preserve author")
    @PropertyDescription(value="Indicate if the authors coming from the events should be kept. If false the current user is used.")
    public boolean isAuthorPreserved() {
        return !this.isAuthorSet() && this.authorPreserved;
    }

    public void setAuthorPreserved(boolean authorPreserved) {
        this.authorPreserved = authorPreserved;
    }

    @PropertyName(value="Stop when document save fails")
    @PropertyDescription(value="Indicate if an exception should be thrown if a document save fails")
    public boolean isStoppedWhenSaveFail() {
        return this.stoppedWhenSaveFail;
    }

    public void setStoppedWhenSaveFail(boolean stoppedWhenSaveFail) {
        this.stoppedWhenSaveFail = stoppedWhenSaveFail;
    }
}

