/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.internal.output;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.CompositeFilterStreamDescriptor;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.instance.output.InstanceOutputProperties;
import org.xwiki.filter.instance.output.OutputInstanceFilterStreamFactory;
import org.xwiki.filter.output.AbstractBeanOutputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;

@Component
@Named(value="xwiki+instance")
@Singleton
public class InstanceOutputFilterStreamFactory
extends AbstractBeanOutputFilterStreamFactory<InstanceOutputProperties, Object> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public InstanceOutputFilterStreamFactory() {
        super(FilterStreamType.XWIKI_INSTANCE);
        this.setName("XWiki instance output stream");
        this.setDescription("Setup XWiki instance from wiki events.");
    }

    public void initialize() throws InitializationException {
        List factories;
        super.initialize();
        try {
            factories = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(OutputInstanceFilterStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to get registered instance of OutputInstanceFilterStreamFactory components", (Throwable)e);
        }
        FilterStreamDescriptor[] descriptors = new FilterStreamDescriptor[factories.size() + 1];
        descriptors[0] = this.descriptor;
        for (int i = 0; i < factories.size(); ++i) {
            descriptors[i + 1] = ((OutputInstanceFilterStreamFactory)factories.get(i)).getDescriptor();
        }
        this.setDescriptor((FilterStreamDescriptor)new CompositeFilterStreamDescriptor(this.descriptor.getName(), this.descriptor.getDescription(), descriptors));
    }

    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        List factories;
        try {
            factories = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(OutputInstanceFilterStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to get regsitered instance of OutputInstanceFilterStreamFactory components", (Throwable)e);
        }
        HashSet filters = new HashSet();
        filters.addAll(super.getFilterInterfaces());
        for (OutputInstanceFilterStreamFactory factory : factories) {
            filters.addAll(factory.getFilterInterfaces());
        }
        return filters;
    }
}

