/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.internal.output;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.instance.output.InstanceOutputProperties;
import org.xwiki.filter.instance.output.OutputInstanceFilterStreamFactory;
import org.xwiki.filter.output.AbstractBeanOutputFilterStream;

@Component
@Named(value="xwiki+instance")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class InstanceOutputFilterStream
extends AbstractBeanOutputFilterStream<InstanceOutputProperties> {
    @Inject
    private FilterDescriptorManager filterManager;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;

    public void setProperties(InstanceOutputProperties properties) throws FilterException {
        List factories;
        super.setProperties((Object)properties);
        try {
            factories = ((ComponentManager)this.componentManager.get()).getInstanceList(OutputInstanceFilterStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to get registered instances of OutputInstanceFilterStreamFactory components", (Throwable)e);
        }
        Object[] filters = new Object[factories.size()];
        int i = 0;
        for (OutputInstanceFilterStreamFactory factory : factories) {
            filters[i++] = factory.createOutputFilterStream(properties).getFilter();
        }
        this.filter = this.filterManager.createCompositeFilter(filters);
    }

    public Object getFilter() throws FilterException {
        return this.filter;
    }

    public void close() throws IOException {
    }
}

