/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.internal.input;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.descriptor.CompositeFilterStreamDescriptor;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.input.AbstractBeanInputFilterStreamFactory;
import org.xwiki.filter.instance.input.InstanceInputEventGenerator;
import org.xwiki.filter.instance.input.InstanceInputProperties;
import org.xwiki.filter.instance.internal.InstanceFilter;
import org.xwiki.filter.type.FilterStreamType;

@Component
@Named(value="xwiki+instance")
@Singleton
public class InstanceInputFilterStreamFactory
extends AbstractBeanInputFilterStreamFactory<InstanceInputProperties, InstanceFilter> {
    public static final String ROLEHINT = "xwiki+instance";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public InstanceInputFilterStreamFactory() {
        super(FilterStreamType.XWIKI_INSTANCE);
        this.setName("XWiki instance input stream");
        this.setDescription("Generates wiki events from XWiki instance.");
    }

    public void initialize() throws InitializationException {
        List eventGenerators;
        super.initialize();
        try {
            eventGenerators = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(InstanceInputEventGenerator.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to get registered instance of InstanceInputEventGenerator components", (Throwable)e);
        }
        FilterStreamDescriptor[] descriptors = new FilterStreamDescriptor[eventGenerators.size() + 1];
        descriptors[0] = this.descriptor;
        for (int i = 0; i < eventGenerators.size(); ++i) {
            descriptors[i + 1] = ((InstanceInputEventGenerator)eventGenerators.get(i)).getDescriptor();
        }
        this.setDescriptor((FilterStreamDescriptor)new CompositeFilterStreamDescriptor(this.descriptor.getName(), this.descriptor.getDescription(), descriptors));
    }

    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        List eventGenerators;
        try {
            eventGenerators = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(InstanceInputEventGenerator.class);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to get registered instance of InstanceInputEventGenerator components", (Throwable)e);
        }
        HashSet filters = new HashSet();
        filters.addAll(super.getFilterInterfaces());
        for (InstanceInputEventGenerator generator : eventGenerators) {
            filters.addAll(generator.getFilterInterfaces());
        }
        return filters;
    }
}

