/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.instance.internal.input;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.event.model.WikiDocumentFilter;
import org.xwiki.filter.input.AbstractBeanInputFilterStream;
import org.xwiki.filter.instance.input.InstanceInputEventGenerator;
import org.xwiki.filter.instance.input.InstanceInputProperties;
import org.xwiki.filter.instance.internal.InstanceFilter;
import org.xwiki.filter.instance.internal.InstanceModel;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceTreeNode;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="xwiki+instance")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class InstanceInputFilterStream
extends AbstractBeanInputFilterStream<InstanceInputProperties, InstanceFilter> {
    private static final TranslationMarker LOG_DOCUMENT_SKIPPED = new TranslationMarker("filter.instance.log.document.skipped", new Marker[]{WikiDocumentFilter.LOG_DOCUMENT_SKIPPED});
    @Inject
    private InstanceModel instanceModel;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private Logger logger;
    private List<InstanceInputEventGenerator> eventGenerators;

    public void setProperties(InstanceInputProperties properties) throws FilterException {
        super.setProperties((Object)properties);
        try {
            this.eventGenerators = ((ComponentManager)this.componentManager.get()).getInstanceList(InstanceInputEventGenerator.class);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to get regsitered instance of OutputInstanceFilterStreamFactory components", (Throwable)e);
        }
        for (InstanceInputEventGenerator eventGenerator : this.eventGenerators) {
            eventGenerator.setProperties((Map)this.properties);
        }
    }

    private boolean isWikiEnabled(WikiReference wikiReference) {
        return ((InstanceInputProperties)this.properties).getEntities() == null || ((InstanceInputProperties)this.properties).getEntities().matches((EntityReference)wikiReference);
    }

    private boolean isSpaceEnabled(SpaceReference spaceReference) {
        return ((InstanceInputProperties)this.properties).getEntities() == null || ((InstanceInputProperties)this.properties).getEntities().matches((EntityReference)spaceReference);
    }

    private boolean isDocumentEnabled(DocumentReference documentReference) {
        return ((InstanceInputProperties)this.properties).getEntities() == null || ((InstanceInputProperties)this.properties).getEntities().matches((EntityReference)documentReference);
    }

    public void close() throws IOException {
    }

    protected void read(Object filter, InstanceFilter proxyFilter) throws FilterException {
        FilterEventParameters parameters = new FilterEventParameters();
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setWikiFarmParameters(parameters);
        }
        proxyFilter.beginWikiFarm(parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setFilter(filter);
            generator.beginWikiFarm(parameters);
        }
        for (WikiReference wikiReference : this.instanceModel.getWikiReferences()) {
            if (!this.isWikiEnabled(wikiReference)) continue;
            this.writeWiki(wikiReference, filter, proxyFilter);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWikiFarm(parameters);
        }
        proxyFilter.endWikiFarm(parameters);
    }

    private void writeWiki(WikiReference wikiReference, Object filter, InstanceFilter proxyFilter) throws FilterException {
        FilterEventParameters parameters = new FilterEventParameters();
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setWikiParameters(wikiReference.getName(), parameters);
        }
        proxyFilter.beginWiki(wikiReference.getName(), parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.beginWiki(wikiReference.getName(), parameters);
        }
        EntityReferenceTreeNode spaces = this.instanceModel.getSpaceReferences(wikiReference);
        for (EntityReferenceTreeNode node : spaces.getChildren()) {
            if (!this.isSpaceEnabled((SpaceReference)node.getReference())) continue;
            this.writeSpace(node, filter, proxyFilter);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWiki(wikiReference.getName(), parameters);
        }
        proxyFilter.endWiki(wikiReference.getName(), parameters);
    }

    private void writeSpace(EntityReferenceTreeNode node, Object filter, InstanceFilter proxyFilter) throws FilterException {
        SpaceReference spaceReference = (SpaceReference)node.getReference();
        FilterEventParameters parameters = new FilterEventParameters();
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setWikiSpaceParameters(spaceReference.getName(), parameters);
        }
        proxyFilter.beginWikiSpace(spaceReference.getName(), parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.beginWikiSpace(spaceReference.getName(), parameters);
        }
        for (DocumentReference documentReference : this.instanceModel.getDocumentReferences(spaceReference)) {
            if (this.isDocumentEnabled(documentReference)) {
                this.writeDocument(documentReference, filter, proxyFilter);
                continue;
            }
            if (!((InstanceInputProperties)this.properties).isVerbose()) continue;
            this.logger.info((Marker)LOG_DOCUMENT_SKIPPED, "Skipped document [{}]", (Object)documentReference);
        }
        for (EntityReferenceTreeNode child : node.getChildren()) {
            if (!this.isSpaceEnabled((SpaceReference)child.getReference())) continue;
            this.writeSpace(child, filter, proxyFilter);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWikiSpace(spaceReference.getName(), parameters);
        }
        proxyFilter.endWikiSpace(spaceReference.getName(), parameters);
    }

    private void writeDocument(DocumentReference documentReference, Object filter, InstanceFilter proxyFilter) throws FilterException {
        FilterEventParameters parameters = new FilterEventParameters();
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.setWikiDocumentParameters(documentReference.getName(), parameters);
        }
        proxyFilter.beginWikiDocument(documentReference.getName(), parameters);
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.beginWikiDocument(documentReference.getName(), parameters);
        }
        for (InstanceInputEventGenerator generator : this.eventGenerators) {
            generator.endWikiDocument(documentReference.getName(), parameters);
        }
        proxyFilter.endWikiDocument(documentReference.getName(), parameters);
    }
}

